% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_generic_indic.R
\name{raw_cg_skewness}
\alias{raw_cg_skewness}
\title{Skewness indicator}
\usage{
raw_cg_skewness(mat, subsize = 5, absolute = TRUE)
}
\arguments{
\item{mat}{A matrix. The matrix 
values can be logical, with \code{FALSE} (empty) or \code{TRUE} (occupied) 
values. The entries can also be continuous (like NDVI or EVI data).}

\item{subsize}{Dimension of the submatrix used to coarse-grain the 
original matrix. This must be an integer less than size of the full 
matrix. Coarse-graining reduces the size of the matrix by a factor 
\code{subsize} in each dimension of the matrix. Skewness is calculated 
on the coarse-grained matrix.}

\item{absolute}{Should the function return the absolute value or raw value 
of skewness ?}
}
\value{
The spatial skewness of the matrix
}
\description{
Compute the spatial skewness of spatial data (a matrix).
}
\details{
Spatial skewness is a measure of fluctuations in space; specifically, it 
measures if fluctuations are getting biased (skewed) in one direction. Based 
on the theory of critical slowing down, when systems approach critical 
points they are expected to show increased fluctuations in space. Thus, 
increasing spatial skewness is proposed as an early warning signal of 
impending critical transitions. 

Computing spatial skewness is straightforward. However, detecting trends of 
skewness that correspond to critical slowing down can be tricky, especially 
if data come from discrete classification of state variable.

Many high resolution spatial data are classified as FALSE (empty) 
or TRUE (occupied by plant). In such cases, spatial skewness captures just 
the skewness in data, but not that of spatial structure. 
To resolve the issue, this function employs a method called coarse-graining, 
proposed in Kefi et al (2014), and described in detail in 
Sankaran et al. (2017). One must specify a subsize above one for 
binary valued data sets to obtain meaningful values. 

\code{subsize} has to be an integer. It has to be less than or equal to 
half of matrix size (N). \code{subsize} must also be preferably a 
divisor of N. If it is not a divisor of N, the remainder rows and columns 
are discarded when computing coarse-graining matrices. 

Null model evaluations are also done on coarse-grained matrices.
}
\examples{

data(serengeti)
\dontrun{
raw_cg_skewness(serengeti[[1]])
compute_indicator(serengeti, fun = raw_cg_skewness, subsize = 5)
}

}
\references{
Guttal, V., and Jayaprakash, C. (2009). Spatial variance and 
spatial skewness: leading indicators of regime shifts in spatial 
ecological systems. Theoretical Ecology, 2(1), 3-12.

Kefi, S., Guttal, V., Brock, W.A., Carpenter, S.R., Ellison, A.M., 
Livina, V.N., et al. (2014). Early Warning Signals of Ecological 
Transitions: Methods for Spatial Patterns. PLoS ONE, 9, e92097.

Sankaran, S., Majumder, S., Kefi, S., and Guttal, V. (2017). Implication of 
being discrete and spatial in detecting early warning signals of regime 
shifts. Ecological indicators.
}
\seealso{
\code{\link{generic_sews}}
}
