\name{rpoislpp}
\alias{rpoislpp}
\title{
  Poisson Point Process on a Linear Network
}
\description{
  Generates a realisation of the Poisson point process
  with specified intensity on the given linear network.
}
\usage{
rpoislpp(lambda, L, \dots, nsim=1, drop=TRUE, ex=NULL)
}
\arguments{
  \item{lambda}{
    Intensity of the Poisson process. 
    A single number, a \code{function(x,y)}, a pixel image
    (object of class \code{"im"}), or a vector of numbers,
    a list of functions, or a list of images.
  }
  \item{L}{
    A linear network (object of class \code{"linnet"},
    see \code{\link{linnet}}).
    Can be omitted in some cases: see Details.
  }
  \item{\dots}{
    Arguments passed to \code{\link[spatstat.random]{rpoisppOnLines}}.
  }
  \item{nsim}{Number of simulated realisations to generate.}
  \item{drop}{
    Logical value indicating what to do when \code{nsim=1}.
    If \code{drop=TRUE} (the default), the result is a point pattern.
    If \code{drop=FALSE}, the result is a list with one entry which is a
    point pattern.
  }
  \item{ex}{
    Optional. A point pattern on a network
    (object of class \code{"lpp"}) which serves as an example
    to determine the default values of \code{lambda} and \code{L}.
    See Details.
  }
}
\details{
  A random number of random points is generated on the network \code{L},
  according to a Poisson point process
  with intensity \code{lambda} points per unit length.
  The random points are generated by \code{\link[spatstat.random]{rpoisppOnLines}}.
  See the help file for \code{\link[spatstat.random]{rpoisppOnLines}} for information.

  Argument \code{L} can be omitted, and defaults to \code{as.linnet(lambda)},
  when \code{lambda} is a function on a linear network (class
  \code{"linfun"}) or a pixel image on a linear network
  (\code{"linim"}).
  
  If \code{ex} is given, then it serves as an example for determining
  \code{lambda} and \code{L}. The default value of \code{lambda}
  will be the average intensity (number per unit length) of points in
  \code{ex} (or the average intensity of the points of each type
  if \code{ex} is multitype). The default value of \code{L} will be 
  the network on which \code{ex} is defined. 
}
\value{
  If \code{nsim = 1} and \code{drop=TRUE},
  a point pattern on the linear network,
  i.e.\ an object of class \code{"lpp"}.
  Otherwise, a list of such point patterns.
}
\author{
  \wei and 
  \adrian 
}
\seealso{
 \code{\link[spatstat.random]{rpoisppOnLines}},
 \code{\link{runiflpp}},
 \code{\link{rlpp}},
 \code{\link{lpp}},
 \code{\link{linnet}}.
}
\examples{
   X <- rpoislpp(5, simplenet)
   plot(X)
   # multitype
   Y <- rpoislpp(c(a=5, b=5), simplenet)
   # using argument 'ex' to make a pattern like 'X'
   Z <- rpoislpp(ex=X)
}
\keyword{spatial}
\keyword{datagen}
\concept{Linear network}
