% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_posteriors_and_derivatives_SPDE.R
\name{logPosterior_SPDE}
\alias{logPosterior_SPDE}
\title{logPosterior_SPDE function}
\usage{
logPosterior_SPDE(surv, X, beta, omega, eta, gamma, priors, cov.model, u,
  control, gradient = FALSE, hessian = FALSE)
}
\arguments{
\item{surv}{an object of class Surv}

\item{X}{the design matrix, containing covariate information}

\item{beta}{parameter beta}

\item{omega}{parameter omega}

\item{eta}{parameter eta}

\item{gamma}{parameter gamma}

\item{priors}{the priors, an object of class 'mcmcPriors'}

\item{cov.model}{the spatial covariance model}

\item{u}{vector of interpoint distances}

\item{control}{a list containg various control parameters for the MCMC and post-processing routines}

\item{gradient}{logical whether to evaluate the gradient}

\item{hessian}{logical whether to evaluate the Hessian}
}
\value{
evaluates the log-posterior and the gradient and hessian, if required.
}
\description{
A function to evaluate the log-posterior of a spatial parametric proportional hazards model. Not intended for general use.
}
\references{
\enumerate{
    \item Benjamin M. Taylor and Barry S. Rowlingson (2017). spatsurv: An R Package for Bayesian Inference with Spatial Survival Models. Journal of Statistical Software, 77(4), 1-32, doi:10.18637/jss.v077.i04.
    \item Finn Lindgren, Havard Rue, Johan Lindstrom. An explicit link between Gaussian fields and Gaussian Markov random fields: the stochastic partial differential equation approach. Journal of the Royal Statistical Society: Series B 73(4)
}
}
