/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Angle;
import partition.EastingNorthing;
import partition.LatLong;

public final class Distance {
    public static final double EQUATORIAL_RADIUS = 6378.137;
    public static final double QUADRATIC_MEAN_RADIUS = 6372.7976;
    public static final double POLAR_RADIUS = 6356.7523;

    private Distance() {
    }

    public static double euclidean(EastingNorthing location1, EastingNorthing location2) {
        return Math.sqrt(Distance.squaredEuclidean(location1, location2));
    }

    public static double euclidean(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Distance.squaredEuclidean(x1, y1, x2, y2));
    }

    public static double squaredEuclidean(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double squaredEuclidean(EastingNorthing location1, EastingNorthing location2) {
        return Distance.squaredEuclidean(location1._s1, location1._s2, location2._s1, location2._s2);
    }

    public static double greatCircleSimple(LatLong location1, LatLong location2) {
        Angle lambda1 = location1.getLambda();
        Angle lambda2 = location2.getLambda();
        Angle delta1 = location1.getDelta();
        Angle delta2 = location2.getDelta();
        double diffLambda = lambda2.getValue() - lambda1.getValue();
        double cosDelta1 = delta1.getCos();
        double cosDelta2 = delta2.getCos();
        double sinDelta1 = delta1.getSin();
        double sinDelta2 = delta2.getSin();
        double greatCircleDistance = 6372.7976 * Math.acos(cosDelta1 * cosDelta2 * Math.cos(diffLambda) + sinDelta1 * sinDelta2);
        return greatCircleDistance;
    }

    public static double greatCircleSimple(double x1, double y1, double x2, double y2) {
        return Distance.greatCircleSimple(new LatLong(x1, y1), new LatLong(x2, y2));
    }

    public static double greatCircle(LatLong location1, LatLong location2) {
        Angle lambda1 = location1.getLambda();
        Angle lambda2 = location2.getLambda();
        Angle delta1 = location1.getDelta();
        Angle delta2 = location2.getDelta();
        double diffLambda = lambda2.getValue() - lambda1.getValue();
        double cosDiffLambda = Math.cos(diffLambda);
        double sinDiffLambda = Math.sin(diffLambda);
        double cosDelta1 = delta1.getCos();
        double cosDelta2 = delta2.getCos();
        double sinDelta1 = delta1.getSin();
        double sinDelta2 = delta2.getSin();
        double n1 = cosDelta2 * sinDiffLambda;
        double n2 = cosDelta1 * sinDelta2;
        double n3 = sinDelta1 * cosDelta2 * cosDiffLambda;
        double n4 = n2 - n3;
        double d1 = sinDelta1 * sinDelta2;
        double d2 = cosDelta1 * cosDelta2 * cosDiffLambda;
        double greatCircleDistance = 6372.7976 * Math.atan2(Math.sqrt(n1 * n1 + n4 * n4), d1 + d2);
        return greatCircleDistance;
    }

    public static double greatCircle(double x1, double y1, double x2, double y2) {
        return Distance.greatCircle(new LatLong(x1, y1), new LatLong(x2, y2));
    }

    public static double greatCircleHav(LatLong location1, LatLong location2) {
        Angle delta1 = location1.getDelta();
        Angle delta2 = location2.getDelta();
        double diffDelta = delta1.getValue() - delta2.getValue();
        double cosDelta1 = delta1.getCos();
        double cosDelta2 = delta2.getCos();
        Angle lambda1 = location1.getLambda();
        Angle lambda2 = location2.getLambda();
        double diffLambda = lambda1.getValue() - lambda2.getValue();
        double greatCircleDistance = 12745.5952 * Math.asin(Math.sqrt(Distance.hav(diffDelta) + cosDelta1 * cosDelta2 * Distance.hav(diffLambda)));
        return greatCircleDistance;
    }

    public static double greatCircleHav(double x1, double y1, double x2, double y2) {
        return Distance.greatCircleHav(new LatLong(x1, y1), new LatLong(x2, y2));
    }

    public static double hav(double a) {
        return 0.5 * (1.0 - Math.cos(a));
    }

    public static double squaredGreatCircle(LatLong location1, LatLong location2) {
        double distance = Distance.greatCircle(location1, location2);
        return distance * distance;
    }

    public static double squaredGreatCircleHav(LatLong location1, LatLong location2) {
        double distance = Distance.greatCircleHav(location1, location2);
        return distance * distance;
    }
}

