% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doShift.R
\name{doShift}
\alias{doShift}
\title{Segment shift}
\usage{
doShift(specSeg, shiftStep)
}
\arguments{
\item{specSeg}{The segment which needs to be shifted}

\item{shiftStep}{The shift step for moving. If it is a negative (positive) value, the segment is moved to left (right).}
}
\value{
The new segment after shifting.
}
\description{
Move a spectral segment of a sample shiftStep points to right or left
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
maxShift=50;
refSpec=X[1,];
tarSpec=X[2,];
adj=findShiftStepFFT(refSpec, tarSpec,maxShift=maxShift);
newTarSpec=doShift(tarSpec,adj$stepAdj);

}
\seealso{
\code{\link{hClustAlign}}, \code{\link{findShiftStepFFT}}
}
\author{
Trung Nghia Vu
}
