/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class CloseableDockableMenuPiece
extends BaseMenuPiece {
    private DockFrontend frontend;
    private Map<Dockable, Item> items = new HashMap<Dockable, Item>();
    private DockableCollector collector = new DockableCollector();

    public CloseableDockableMenuPiece() {
    }

    public CloseableDockableMenuPiece(DockFrontend dockFrontend) {
        this.setFrontend(dockFrontend);
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend dockFrontend) {
        if (this.frontend != dockFrontend) {
            if (this.frontend != null) {
                this.frontend.removeFrontendListener(this.collector);
                for (Item object : this.items.values()) {
                    object.destroy();
                    this.remove(object);
                }
                this.items.clear();
            }
            this.frontend = dockFrontend;
            if (this.frontend != null) {
                this.frontend.addFrontendListener(this.collector);
                for (Dockable dockable : this.frontend.listDockables()) {
                    this.collector.added(dockFrontend, dockable);
                }
            }
        }
    }

    protected Item create(Dockable dockable) {
        return new Item(dockable);
    }

    protected void insert(Item item) {
        this.add(item);
    }

    protected void show(Dockable dockable) {
        this.frontend.show(dockable);
    }

    protected void hide(Dockable dockable) {
        this.frontend.hide(dockable);
    }

    protected boolean include(Dockable dockable) {
        return this.frontend.isHideable(dockable);
    }

    public void check(Dockable dockable) {
        if (this.include(dockable)) {
            if (!this.items.containsKey(dockable)) {
                this.collector.added(this.frontend, dockable);
            }
        } else if (this.items.containsKey(dockable)) {
            this.collector.removed(this.frontend, dockable);
        }
    }

    protected class Item
    extends JCheckBoxMenuItem
    implements DockableListener,
    ActionListener {
        private Dockable dockable;
        private boolean onChange = false;

        public Item(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockableListener(this);
            this.addActionListener(this);
            this.setIcon(dockable.getTitleIcon());
            this.setText(dockable.getTitleText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDockableState(boolean bl) {
            try {
                this.onChange = true;
                this.setSelected(bl);
            }
            finally {
                this.onChange = false;
            }
        }

        public void destroy() {
            this.dockable.removeDockableListener(this);
            this.removeActionListener(this);
            this.setIcon(null);
            this.setText("");
        }

        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            this.setIcon(icon2);
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            this.setText(string2);
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
        }

        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.onChange) {
                if (this.isSelected()) {
                    CloseableDockableMenuPiece.this.show(this.dockable);
                } else {
                    CloseableDockableMenuPiece.this.hide(this.dockable);
                }
            }
        }
    }

    private class DockableCollector
    extends DockFrontendAdapter {
        private DockableCollector() {
        }

        public void hidden(DockFrontend dockFrontend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.get(dockable);
            if (item != null) {
                item.setDockableState(false);
            }
        }

        public void shown(DockFrontend dockFrontend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.get(dockable);
            if (item != null) {
                item.setDockableState(true);
            }
        }

        public void added(DockFrontend dockFrontend, Dockable dockable) {
            if (CloseableDockableMenuPiece.this.include(dockable)) {
                Item item = CloseableDockableMenuPiece.this.create(dockable);
                item.setDockableState(dockFrontend.isShown(dockable));
                CloseableDockableMenuPiece.this.items.put(dockable, item);
                CloseableDockableMenuPiece.this.insert(item);
            }
        }

        public void removed(DockFrontend dockFrontend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.remove(dockable);
            if (item != null) {
                item.destroy();
                CloseableDockableMenuPiece.this.remove(item);
            }
        }

        public void hideable(DockFrontend dockFrontend, Dockable dockable, boolean bl) {
            CloseableDockableMenuPiece.this.check(dockable);
        }
    }
}

