/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.themes.color.MenuColor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleTabMenu
extends AbstractCombinedMenu {
    private StackDockComponentParent station;
    private BubbleMenuColor colorTopMouse;
    private BubbleMenuColor colorBottomMouse;
    private BubbleMenuColor colorBorderMouse;
    private BubbleMenuColor colorTop;
    private BubbleMenuColor colorBottom;
    private BubbleMenuColor colorBorder;
    private BubbleColorAnimation animation;
    private boolean mouseOver;
    private int borderSize = 3;

    public BubbleTabMenu(StackDockComponentParent stackDockComponentParent, TabPane tabPane, CombinedHandler<CombinedMenu> combinedHandler) {
        super(tabPane, combinedHandler);
        this.station = stackDockComponentParent;
        this.colorTopMouse = new BubbleMenuColor("stack.menu.background.top.mouse", Color.RED.brighter());
        this.colorBottomMouse = new BubbleMenuColor("stack.menu.background.bottom.mouse", Color.RED.darker());
        this.colorBorderMouse = new BubbleMenuColor("stack.menu.border.mouse", Color.RED.darker().darker());
        this.colorTop = new BubbleMenuColor("stack.menu.background.top", Color.RED.brighter());
        this.colorBottom = new BubbleMenuColor("stack.menu.background.bottom", Color.RED.darker());
        this.colorBorder = new BubbleMenuColor("stack.menu.border", Color.RED.darker().darker());
        this.animation = new BubbleColorAnimation();
        this.animate();
        this.animation.kick();
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.colorTopMouse.connect(dockController);
        this.colorBottomMouse.connect(dockController);
        this.colorBorderMouse.connect(dockController);
        this.colorTop.connect(dockController);
        this.colorBottom.connect(dockController);
        this.colorBorder.connect(dockController);
        this.animate();
        this.animation.kick();
    }

    public void stopAnimation() {
        this.animation.stop();
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private void animate() {
        if (this.isMouseOver()) {
            this.animation.putColor("top", this.colorTopMouse.color());
            this.animation.putColor("bottom", this.colorBottomMouse.color());
            this.animation.putColor("border", this.colorBorderMouse.color());
        } else {
            this.animation.putColor("top", this.colorTop.color());
            this.animation.putColor("bottom", this.colorBottom.color());
            this.animation.putColor("border", this.colorBorder.color());
        }
    }

    @Override
    protected Component createComponent() {
        return new Button();
    }

    @Override
    protected void selected(Dockable dockable) {
    }

    protected class BubbleMenuColor
    extends MenuColor {
        public BubbleMenuColor(String string, Color color) {
            super(string, BubbleTabMenu.this.station.getStation(), BubbleTabMenu.this, color);
        }

        protected void changed(Color color, Color color2) {
            BubbleTabMenu.this.animate();
        }
    }

    private class Button
    extends JPanel
    implements Runnable {
        public Button() {
            this.setOpaque(false);
            BubbleTabMenu.this.animation.addTask(this);
            this.setPreferredSize(new Dimension(20, 20));
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    BubbleTabMenu.this.mouseOver = true;
                    BubbleTabMenu.this.animate();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    BubbleTabMenu.this.mouseOver = false;
                    BubbleTabMenu.this.animate();
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    BubbleTabMenu.this.open();
                }
            });
        }

        public void run() {
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            Color color = BubbleTabMenu.this.animation.getColor("top");
            Color color2 = BubbleTabMenu.this.animation.getColor("bottom");
            Color color3 = BubbleTabMenu.this.animation.getColor("border");
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(color3);
            graphics2D.fillOval(0, 0, n, n2);
            if (n > 2 * BubbleTabMenu.this.borderSize && n2 > 2 * BubbleTabMenu.this.borderSize) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n2 - BubbleTabMenu.this.borderSize, color2));
                graphics2D.fillOval(BubbleTabMenu.this.borderSize, BubbleTabMenu.this.borderSize, n - 2 * BubbleTabMenu.this.borderSize, n2 - 2 * BubbleTabMenu.this.borderSize);
            }
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, n2 / 2, Color.WHITE));
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
            graphics2D.fillArc(0, 0, n, n2, 0, 180);
            graphics2D.dispose();
        }
    }
}

