/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.event.DockRelocatorListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DockRelocator {
    private List<DockRelocatorListener> listeners = new ArrayList<DockRelocatorListener>();
    private DockController controller;
    private int dragDistance = 10;
    private boolean dragOnlyTitel = false;
    private List<DockRelocatorMode> modes = new ArrayList<DockRelocatorMode>();
    private Set<DockRelocatorMode> activeModes = new HashSet<DockRelocatorMode>();
    private Merger merger = null;

    public DockRelocator(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockRelocatorListener(DockRelocatorListener dockRelocatorListener) {
        this.listeners.add(dockRelocatorListener);
    }

    public void removeDockRelocatorListener(DockRelocatorListener dockRelocatorListener) {
        this.listeners.remove(dockRelocatorListener);
    }

    protected DockRelocatorListener[] listListeners() {
        return this.listeners.toArray(new DockRelocatorListener[this.listeners.size()]);
    }

    protected void fireInit(Dockable dockable) {
        for (DockRelocatorListener dockRelocatorListener : this.listListeners()) {
            dockRelocatorListener.init(this.controller, dockable);
        }
    }

    protected void fireCancel(Dockable dockable) {
        for (DockRelocatorListener dockRelocatorListener : this.listListeners()) {
            dockRelocatorListener.cancel(this.controller, dockable);
        }
    }

    protected void fireDrag(Dockable dockable, DockStation dockStation) {
        for (DockRelocatorListener dockRelocatorListener : this.listListeners()) {
            dockRelocatorListener.drag(this.controller, dockable, dockStation);
        }
    }

    protected void fireDrop(Dockable dockable, DockStation dockStation) {
        for (DockRelocatorListener dockRelocatorListener : this.listListeners()) {
            dockRelocatorListener.drop(this.controller, dockable, dockStation);
        }
    }

    public boolean isDragOnlyTitel() {
        return this.dragOnlyTitel;
    }

    public void setDragOnlyTitel(boolean bl) {
        this.dragOnlyTitel = bl;
    }

    public int getDragDistance() {
        return this.dragDistance;
    }

    public void setDragDistance(int n) {
        this.dragDistance = n;
    }

    public Merger getMerger() {
        return this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    public void addMode(DockRelocatorMode dockRelocatorMode) {
        if (dockRelocatorMode == null) {
            throw new IllegalArgumentException("Mode must not be null");
        }
        this.modes.add(dockRelocatorMode);
    }

    public void removeMode(DockRelocatorMode dockRelocatorMode) {
        if (this.activeModes.remove(dockRelocatorMode)) {
            dockRelocatorMode.setActive(this.controller, false);
        }
        this.modes.remove(dockRelocatorMode);
    }

    protected void disableAllModes() {
        for (DockRelocatorMode dockRelocatorMode : this.activeModes) {
            dockRelocatorMode.setActive(this.controller, false);
        }
        this.activeModes.clear();
    }

    protected void checkModes(int n) {
        for (DockRelocatorMode dockRelocatorMode : this.modes) {
            boolean bl = dockRelocatorMode.shouldBeActive(this.controller, n);
            if (bl) {
                if (!this.activeModes.add(dockRelocatorMode)) continue;
                dockRelocatorMode.setActive(this.controller, true);
                continue;
            }
            if (!this.activeModes.remove(dockRelocatorMode)) continue;
            dockRelocatorMode.setActive(this.controller, false);
        }
    }

    public abstract boolean isOnMove();

    public abstract boolean isOnPut();

    public abstract DirectRemoteRelocator createDirectRemote(Dockable var1);

    public abstract RemoteRelocator createRemote(Dockable var1);
}

