/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedDockSituation
extends DockSituation {
    private Map<String, DockElement> stringToElement = new HashMap<String, DockElement>();
    private Map<DockElement, String> elementToString = new HashMap<DockElement, String>();
    private static final String KNOWN = "predefined";
    private static final String UNKNOWN = "delegate_";
    private Map<String, DockFactory<? extends DockElement, BackupFactoryData<?>>> backups = new HashMap();
    private final PreloadFactory factory = new PreloadFactory();

    public void addBackup(DockFactory<? extends DockElement, BackupFactoryData<?>> dockFactory) {
        this.backups.put(UNKNOWN + dockFactory.getID(), dockFactory);
    }

    public void removeBackup(String string) {
        this.backups.remove(UNKNOWN + string);
    }

    @Deprecated
    public void put(DockElement dockElement) {
        this.put(String.valueOf(this.stringToElement.size()), dockElement);
    }

    public void put(String string, DockElement dockElement) {
        if (this.stringToElement.containsKey(string)) {
            throw new IllegalArgumentException("Key does already exist: " + string);
        }
        this.stringToElement.put(string, dockElement);
        this.elementToString.put(dockElement, string);
    }

    protected boolean shouldLayout(DockElement dockElement) {
        return true;
    }

    @Override
    protected DockLayoutInfo fillMissing(DockLayoutInfo dockLayoutInfo) {
        DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
        if (KNOWN.equals(dockLayout.getFactoryID())) {
            PreloadedLayout preloadedLayout = (PreloadedLayout)dockLayout.getData();
            DockLayoutInfo dockLayoutInfo2 = preloadedLayout.getDelegate();
            DockLayoutInfo dockLayoutInfo3 = null;
            if (dockLayoutInfo2.getKind() == DockLayoutInfo.Data.BYTE) {
                dockLayoutInfo3 = this.fillMissingStream(preloadedLayout);
            } else if (dockLayoutInfo2.getKind() == DockLayoutInfo.Data.XML) {
                dockLayoutInfo3 = this.fillMissingXML(preloadedLayout);
            }
            if (dockLayoutInfo3 != null) {
                dockLayoutInfo = new DockLayoutInfo(new DockLayout<PreloadedLayout>(KNOWN, new PreloadedLayout(preloadedLayout.getPreload(), dockLayoutInfo3)));
            }
        }
        return dockLayoutInfo;
    }

    public <D extends DockElement> Set<D> listVisible(Collection<D> collection, DockLayoutComposition dockLayoutComposition) {
        HashSet hashSet = new HashSet();
        this.listVisible(collection, dockLayoutComposition, hashSet);
        return hashSet;
    }

    private <D extends DockElement> void listVisible(final Collection<D> collection, DockLayoutComposition dockLayoutComposition, final Set<D> set) {
        PreloadedLayout object3;
        String string;
        DockElement dockElement;
        Object object2;
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && KNOWN.equals(((DockLayout)(object2 = dockLayoutInfo.getDataLayout())).getFactoryID()) && (dockElement = this.stringToElement.get(string = (object3 = (PreloadedLayout)((DockLayout)object2).getData()).getPreload())) != null) {
            if (collection.contains(dockElement)) {
                set.add(dockElement);
            }
            if (dockLayoutComposition.isIgnoreChildren()) {
                DockUtilities.visit(dockElement, new DockUtilities.DockVisitor(){

                    public void handleDockable(Dockable dockable) {
                        if (collection.contains(dockable)) {
                            set.add(dockable);
                        }
                    }

                    public void handleDockStation(DockStation dockStation) {
                        if (collection.contains(dockStation)) {
                            set.add(dockStation);
                        }
                    }
                });
            }
        }
        for (DockLayoutComposition dockLayoutComposition2 : dockLayoutComposition.getChildren()) {
            this.listVisible(collection, dockLayoutComposition2, set);
        }
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition dockLayoutComposition, boolean bl) {
        return this.listEstimatedLocations(dockLayoutComposition, dockLayoutComposition.getLayout().getLocation(), bl);
    }

    public Map<String, DockableProperty> listEstimatedLocations(DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty, boolean bl) {
        String string;
        this.estimateLocations(dockLayoutComposition, dockableProperty);
        HashMap<String, DockableProperty> hashMap = new HashMap<String, DockableProperty>();
        this.listEstimatedLocations(dockLayoutComposition, bl, hashMap);
        if (dockableProperty != null && (string = this.getKey(dockLayoutComposition, bl)) != null) {
            hashMap.put(string, dockableProperty);
        }
        return hashMap;
    }

    private void listEstimatedLocations(DockLayoutComposition dockLayoutComposition, boolean bl, Map<String, DockableProperty> map) {
        Object object;
        DockableProperty dockableProperty = dockLayoutComposition.getLayout().getLocation();
        if (dockableProperty != null && (object = this.getKey(dockLayoutComposition, bl)) != null) {
            map.put((String)object, dockableProperty);
        }
        if ((object = dockLayoutComposition.getChildren()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DockLayoutComposition dockLayoutComposition2 = (DockLayoutComposition)iterator.next();
                this.listEstimatedLocations(dockLayoutComposition2, bl, map);
            }
        }
    }

    public Map<String, DockLayoutComposition> listLayouts(DockLayoutComposition dockLayoutComposition, boolean bl) {
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        this.listLayouts(dockLayoutComposition, bl, hashMap);
        return hashMap;
    }

    private void listLayouts(DockLayoutComposition dockLayoutComposition, boolean bl, Map<String, DockLayoutComposition> map) {
        List<DockLayoutComposition> list;
        String string = this.getKey(dockLayoutComposition, bl);
        if (string != null) {
            map.put(string, dockLayoutComposition);
        }
        if ((list = dockLayoutComposition.getChildren()) != null) {
            for (DockLayoutComposition dockLayoutComposition2 : list) {
                this.listLayouts(dockLayoutComposition2, bl, map);
            }
        }
    }

    private String getKey(DockLayoutComposition dockLayoutComposition, boolean bl) {
        DockLayoutInfo dockLayoutInfo = dockLayoutComposition.getLayout();
        if (dockLayoutInfo.getKind() != DockLayoutInfo.Data.DOCK_LAYOUT) {
            return null;
        }
        if (!KNOWN.equals(dockLayoutInfo.getDataLayout().getFactoryID())) {
            return null;
        }
        PreloadedLayout preloadedLayout = (PreloadedLayout)dockLayoutInfo.getDataLayout().getData();
        if (bl && preloadedLayout.getDelegate().getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && this.stringToElement.containsKey(preloadedLayout.getPreload())) {
            return null;
        }
        String string = preloadedLayout.getPreload();
        return string;
    }

    private DockLayoutInfo fillMissingStream(PreloadedLayout preloadedLayout) {
        byte[] byArray = preloadedLayout.getDelegate().getDataByte();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            String string = dataInputStream.readUTF();
            DockFactory<DockElement, ?> dockFactory = this.getFactory(string);
            DockLayoutInfo dockLayoutInfo = null;
            if (dockFactory == null) {
                BackupFactoryData backupFactoryData;
                DockFactory<DockElement, BackupFactoryData<?>> dockFactory2 = this.getBackup(string);
                if (dockFactory2 != null && (backupFactoryData = (BackupFactoryData)dockFactory2.read(dataInputStream, this.getPlaceholderStrategy())) != null && backupFactoryData.getData() != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, backupFactoryData.getData()));
                }
            } else {
                Object l = dockFactory.read(dataInputStream, this.getPlaceholderStrategy());
                if (l != null) {
                    dockLayoutInfo = new DockLayoutInfo(new DockLayout(string, l));
                }
            }
            dataInputStream.close();
            return dockLayoutInfo;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read stream", iOException);
        }
    }

    private DockLayoutInfo fillMissingXML(PreloadedLayout preloadedLayout) {
        XElement xElement = preloadedLayout.getDelegate().getDataXML();
        String string = xElement.getString("id");
        Object l = null;
        DockFactory<DockElement, ?> dockFactory = this.getFactory(string);
        if (dockFactory == null) {
            BackupFactoryData backupFactoryData;
            DockFactory<DockElement, BackupFactoryData<?>> dockFactory2 = this.getBackup(string);
            if (dockFactory2 != null && (backupFactoryData = (BackupFactoryData)dockFactory2.read(xElement, this.getPlaceholderStrategy())) != null) {
                l = backupFactoryData.getData();
            }
        } else {
            l = dockFactory.read(xElement, this.getPlaceholderStrategy());
        }
        if (l == null) {
            return null;
        }
        return new DockLayoutInfo(new DockLayout<Object>(string, l));
    }

    @Override
    public String getID(DockElement dockElement) {
        String string = this.elementToString.get(dockElement);
        if (string == null) {
            return UNKNOWN + super.getID(dockElement);
        }
        return KNOWN;
    }

    @Override
    protected String getID(DockFactory<?, ?> dockFactory) {
        if (dockFactory == this.factory) {
            return KNOWN;
        }
        return UNKNOWN + super.getID(dockFactory);
    }

    @Override
    protected String getFactoryID(String string) {
        if (KNOWN.equals(string)) {
            return this.factory.getID();
        }
        return string.substring(UNKNOWN.length());
    }

    public static String convertFactoryID(String string) {
        return UNKNOWN + string;
    }

    @Override
    protected DockFactory<? extends DockElement, ?> getFactory(String string) {
        if (KNOWN.equals(string)) {
            return this.factory;
        }
        return super.getFactory(string);
    }

    protected DockFactory<? extends DockElement, BackupFactoryData<?>> getBackup(String string) {
        return this.backups.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreloadFactory
    implements DockFactory<DockElement, PreloadedLayout> {
        private PreloadFactory() {
        }

        @Override
        public String getID() {
            return PredefinedDockSituation.KNOWN;
        }

        @Override
        public void estimateLocations(PreloadedLayout preloadedLayout, LocationEstimationMap locationEstimationMap) {
            String string;
            DockFactory<DockElement, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                dockFactory.estimateLocations(dockLayoutInfo.getDataLayout().getData(), locationEstimationMap);
            }
        }

        @Override
        public PreloadedLayout getLayout(DockElement dockElement, Map<Dockable, Integer> map) {
            if (PredefinedDockSituation.this.shouldLayout(dockElement)) {
                String string = PredefinedDockSituation.UNKNOWN + PredefinedDockSituation.super.getID(dockElement);
                DockFactory<DockElement, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new IllegalStateException("Missing factory: " + string);
                }
                Object l = dockFactory.getLayout(dockElement, map);
                DockLayout dockLayout = new DockLayout(string, l);
                return new PreloadedLayout((String)PredefinedDockSituation.this.elementToString.get(dockElement), new DockLayoutInfo(dockLayout));
            }
            return new PreloadedLayout((String)PredefinedDockSituation.this.elementToString.get(dockElement), new DockLayoutInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLayout(DockElement dockElement, PreloadedLayout preloadedLayout, Map<Integer, Dockable> map) {
            String string;
            DockFactory<DockElement, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(dockElement) && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                DockController dockController = dockElement.getController();
                try {
                    if (dockController != null) {
                        dockController.freezeLayout();
                    }
                    dockFactory.setLayout(dockElement, dockLayoutInfo.getDataLayout().getData(), map);
                }
                finally {
                    if (dockController != null) {
                        dockController.meltLayout();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLayout(DockElement dockElement, PreloadedLayout preloadedLayout) {
            String string;
            DockFactory<DockElement, ?> dockFactory;
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT && PredefinedDockSituation.this.shouldLayout(dockElement) && (dockFactory = PredefinedDockSituation.this.getFactory(string = dockLayoutInfo.getDataLayout().getFactoryID())) != null) {
                DockController dockController = dockElement.getController();
                try {
                    if (dockController != null) {
                        dockController.freezeLayout();
                    }
                    dockFactory.setLayout(dockElement, dockLayoutInfo.getDataLayout().getData());
                }
                finally {
                    if (dockController != null) {
                        dockController.meltLayout();
                    }
                }
            }
        }

        @Override
        public DockElement layout(PreloadedLayout preloadedLayout, Map<Integer, Dockable> map) {
            boolean bl;
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            boolean bl2 = dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl3 = bl = dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL;
            if (!bl2 && !bl) {
                return null;
            }
            DockElement dockElement = (DockElement)PredefinedDockSituation.this.stringToElement.get(preloadedLayout.getPreload());
            if (dockElement == null && bl2) {
                String string = dockLayoutInfo.getDataLayout().getFactoryID();
                DockFactory<DockElement, BackupFactoryData<?>> dockFactory = PredefinedDockSituation.this.getBackup(string);
                if (dockFactory != null) {
                    return dockFactory.layout(new BackupFactoryData(preloadedLayout.getPreload(), dockLayoutInfo.getDataLayout().getData()), map);
                }
                return null;
            }
            this.setLayout(dockElement, preloadedLayout, map);
            return dockElement;
        }

        @Override
        public DockElement layout(PreloadedLayout preloadedLayout) {
            boolean bl;
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            boolean bl2 = dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT;
            boolean bl3 = bl = dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL;
            if (!bl2 && !bl) {
                return null;
            }
            DockElement dockElement = (DockElement)PredefinedDockSituation.this.stringToElement.get(preloadedLayout.getPreload());
            if (dockElement == null && bl2) {
                if (preloadedLayout.getDelegate() == null) {
                    return null;
                }
                String string = dockLayoutInfo.getDataLayout().getFactoryID();
                DockFactory<DockElement, BackupFactoryData<?>> dockFactory = PredefinedDockSituation.this.getBackup(string);
                if (dockFactory != null) {
                    return dockFactory.layout(new BackupFactoryData(preloadedLayout.getPreload(), dockLayoutInfo.getDataLayout().getData()));
                }
                return null;
            }
            this.setLayout(dockElement, preloadedLayout);
            return dockElement;
        }

        @Override
        public void write(PreloadedLayout preloadedLayout, DataOutputStream dataOutputStream) throws IOException {
            Version.write(dataOutputStream, Version.VERSION_1_0_7);
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            dataOutputStream.writeUTF(preloadedLayout.getPreload());
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.BYTE) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.write(dockLayoutInfo.getDataByte());
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                dataOutputStream.writeBoolean(true);
                DockLayout<?> dockLayout = dockLayoutInfo.getDataLayout();
                String string = dockLayout.getFactoryID();
                DockFactory<DockElement, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new IOException("Missing factory: " + string);
                }
                dataOutputStream.writeUTF(string);
                dockFactory.write(dockLayout.getData(), dataOutputStream);
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.NULL) {
                dataOutputStream.writeBoolean(false);
            } else {
                throw new IllegalArgumentException("Cannot store information as byte[], it is not present as raw byte[] or in an understandable format");
            }
        }

        @Override
        public PreloadedLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
            Version version = Version.read(dataInputStream);
            version.checkCurrent();
            boolean bl = Version.VERSION_1_0_7.compareTo(version) <= 0;
            String string = dataInputStream.readUTF();
            boolean bl2 = false;
            if (bl) {
                bl2 = !dataInputStream.readBoolean();
            }
            DockLayoutInfo dockLayoutInfo = null;
            if (bl2) {
                dockLayoutInfo = new DockLayoutInfo();
            } else {
                String string2 = dataInputStream.readUTF();
                DockFactory<DockElement, ?> dockFactory = PredefinedDockSituation.this.getFactory(string2);
                if (dockFactory == null) {
                    DockFactory<DockElement, BackupFactoryData<?>> dockFactory2 = PredefinedDockSituation.this.getBackup(string2);
                    if (dockFactory2 != null) {
                        BackupFactoryData backupFactoryData = (BackupFactoryData)dockFactory2.read(dataInputStream, placeholderStrategy);
                        if (backupFactoryData != null && backupFactoryData.getData() != null) {
                            dockLayoutInfo = new DockLayoutInfo(new DockLayout(string2, backupFactoryData.getData()));
                        }
                    } else {
                        int n;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream.writeUTF(string2);
                        while ((n = dataInputStream.read()) != -1) {
                            dataOutputStream.write(n);
                        }
                        dataOutputStream.close();
                        dockLayoutInfo = new DockLayoutInfo(byteArrayOutputStream.toByteArray());
                    }
                } else {
                    Object l = dockFactory.read(dataInputStream, placeholderStrategy);
                    if (l != null) {
                        dockLayoutInfo = new DockLayoutInfo(new DockLayout(string2, l));
                    }
                }
            }
            if (dockLayoutInfo == null) {
                return null;
            }
            return new PreloadedLayout(string, dockLayoutInfo);
        }

        @Override
        public void write(PreloadedLayout preloadedLayout, XElement xElement) {
            xElement.addElement("replacement").addString("id", preloadedLayout.getPreload());
            DockLayoutInfo dockLayoutInfo = preloadedLayout.getDelegate();
            if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.XML) {
                xElement.addElement(dockLayoutInfo.getDataXML());
            } else if (dockLayoutInfo.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
                DockLayout<?> dockLayout = preloadedLayout.getDelegate().getDataLayout();
                String string = dockLayout.getFactoryID();
                DockFactory<DockElement, ?> dockFactory = PredefinedDockSituation.this.getFactory(string);
                if (dockFactory == null) {
                    throw new XException("Missing factory: " + string);
                }
                XElement xElement2 = xElement.addElement("delegate");
                xElement2.addString("id", string);
                dockFactory.write(dockLayout.getData(), xElement2);
            } else if (dockLayoutInfo.getKind() != DockLayoutInfo.Data.NULL) {
                throw new IllegalArgumentException("Cannot store information as xml, it is neither present as raw xml nor in an understandable format");
            }
        }

        @Override
        public PreloadedLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
            DockFactory<DockElement, BackupFactoryData<?>> dockFactory;
            String string = xElement.getElement("replacement").getString("id");
            XElement xElement2 = xElement.getElement("delegate");
            if (xElement2 == null) {
                return new PreloadedLayout(string, new DockLayoutInfo());
            }
            String string2 = xElement2.getString("id");
            Object l = null;
            DockFactory<DockElement, ?> dockFactory2 = PredefinedDockSituation.this.getFactory(string2);
            if (dockFactory2 == null) {
                BackupFactoryData backupFactoryData;
                dockFactory = PredefinedDockSituation.this.getBackup(string2);
                if (dockFactory != null && (backupFactoryData = (BackupFactoryData)dockFactory.read(xElement2, placeholderStrategy)) != null) {
                    l = backupFactoryData.getData();
                }
            } else {
                l = dockFactory2.read(xElement2, placeholderStrategy);
            }
            if (l == null) {
                return new PreloadedLayout(string, new DockLayoutInfo(xElement2));
            }
            dockFactory = new DockLayout<Object>(string2, l);
            return new PreloadedLayout(string, new DockLayoutInfo((DockLayout<?>)((Object)dockFactory)));
        }
    }

    private static class PreloadedLayout {
        private DockLayoutInfo delegate;
        private String preload;

        public PreloadedLayout(String string, DockLayoutInfo dockLayoutInfo) {
            this.preload = string;
            this.delegate = dockLayoutInfo;
        }

        public String getPreload() {
            return this.preload;
        }

        public DockLayoutInfo getDelegate() {
            return this.delegate;
        }
    }
}

