/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabContentFilter;
import javax.swing.Icon;

public class DefaultTabContentFilter
extends AbstractTabContentFilter {
    private Behavior deselected;
    private Behavior selected;

    public DefaultTabContentFilter() {
        this(Behavior.ALL);
    }

    public DefaultTabContentFilter(Behavior behavior) {
        this(behavior, behavior);
    }

    public DefaultTabContentFilter(Behavior behavior, Behavior behavior2) {
        this.setSelected(behavior);
        this.setDeselected(behavior2);
    }

    public void setSelected(Behavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("selected must not be null");
        }
        if (this.selected != behavior) {
            this.selected = behavior;
            this.fireChanged();
        }
    }

    public Behavior getSelected() {
        return this.selected;
    }

    public void setDeselected(Behavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("deselected must not be null");
        }
        if (this.deselected != behavior) {
            this.deselected = behavior;
            this.fireChanged();
        }
    }

    public Behavior getDeselected() {
        return this.deselected;
    }

    public TabContent filter(TabContent tabContent, StackDockStation stackDockStation, Dockable dockable) {
        boolean bl = stackDockStation.getFrontDockable() == dockable;
        return this.filter(tabContent, bl ? this.selected : this.deselected);
    }

    public TabContent filter(TabContent tabContent, StackDockComponent stackDockComponent, Dockable dockable) {
        int n = stackDockComponent.getSelectedIndex();
        boolean bl = n >= 0 && stackDockComponent.getDockableAt(n) == dockable;
        return this.filter(tabContent, bl ? this.selected : this.deselected);
    }

    protected void selected(StackDockStation stackDockStation, Dockable dockable) {
        if (this.selected != this.deselected) {
            this.fireChanged(dockable);
        }
    }

    protected void deselected(StackDockStation stackDockStation, Dockable dockable) {
        if (this.selected != this.deselected) {
            this.fireChanged(dockable);
        }
    }

    protected void selectionChanged(StackDockComponent stackDockComponent) {
        if (this.selected != this.deselected) {
            this.fireChanged(stackDockComponent);
        }
    }

    private TabContent filter(TabContent tabContent, Behavior behavior) {
        Icon icon = tabContent.getIcon();
        String string = tabContent.getTitle();
        String string2 = tabContent.getTooltip();
        switch (behavior) {
            case ICON_ONLY: {
                string = null;
                break;
            }
            case ICON_OVER_TEXT: {
                if (icon == null) break;
                string = null;
                break;
            }
            case TEXT_ONLY: {
                icon = null;
                break;
            }
            case TEXT_OVER_ICON: {
                if (string == null) break;
                icon = null;
            }
        }
        return new TabContent(icon, string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Behavior {
        ALL,
        ICON_ONLY,
        TEXT_ONLY,
        ICON_OVER_TEXT,
        TEXT_OVER_ICON;

    }
}

