/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PriorityValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class IconManager {
    private Map<String, Entry> icons = new HashMap<String, Entry>();

    private Entry getEntry(String string) {
        Entry entry = this.icons.get(string);
        if (entry == null) {
            entry = new Entry(string);
            this.icons.put(string, entry);
        }
        return entry;
    }

    public void setIcon(String string, Priority priority, Icon icon) {
        this.getEntry(string).setIcon(priority, icon);
    }

    public void setIconDefault(String string, Icon icon) {
        this.setIcon(string, Priority.DEFAULT, icon);
    }

    public void setIconTheme(String string, Icon icon) {
        this.setIcon(string, Priority.THEME, icon);
    }

    public void setIconClient(String string, Icon icon) {
        this.setIcon(string, Priority.CLIENT, icon);
    }

    public Icon getIcon(String string) {
        return this.getEntry(string).getIcon();
    }

    public void add(String string, IconManagerListener iconManagerListener) {
        this.getEntry(string).add(iconManagerListener);
    }

    public void remove(String string, IconManagerListener iconManagerListener) {
        this.getEntry(string).remove(iconManagerListener);
    }

    public void clearThemeIcons() {
        for (Entry entry : this.icons.values()) {
            entry.setIcon(Priority.THEME, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    extends PriorityValue<Icon> {
        private String key;
        private List<IconManagerListener> listeners = new ArrayList<IconManagerListener>();

        public Entry(String string) {
            this.key = string;
        }

        public Icon getIcon() {
            return (Icon)this.get();
        }

        public void setIcon(Priority priority, Icon icon) {
            Icon icon2 = this.getIcon();
            this.set(priority, icon);
            Icon icon3 = this.getIcon();
            if (icon2 != icon3) {
                for (IconManagerListener iconManagerListener : this.listeners.toArray(new IconManagerListener[this.listeners.size()])) {
                    iconManagerListener.iconChanged(this.key, icon3);
                }
            }
        }

        public void add(IconManagerListener iconManagerListener) {
            if (iconManagerListener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.listeners.add(iconManagerListener);
        }

        public void remove(IconManagerListener iconManagerListener) {
            this.listeners.remove(iconManagerListener);
        }
    }
}

