/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective.mode;

import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.LocationHistory;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.CLocationModeSettings;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationModeManagerPerspective {
    private CPerspective perspective;
    private Map<ExtendedMode, LocationModePerspective> modes = new HashMap<ExtendedMode, LocationModePerspective>();
    private Map<Path, ModeSettingFactory<Location>> settingFactories = new HashMap<Path, ModeSettingFactory<Location>>();

    public LocationModeManagerPerspective(CPerspective perspective, CControlAccess control) {
        this.perspective = perspective;
        for (ModeSettingFactory factory : control.getLocationManager().getFactories()) {
            this.settingFactories.put(factory.getModeId(), factory);
        }
    }

    public ExtendedMode getMode(Path identifier) {
        for (ExtendedMode mode : this.modes.keySet()) {
            if (!mode.getModeIdentifier().equals(identifier)) continue;
            return mode;
        }
        return null;
    }

    public void addMode(LocationModePerspective mode) {
        this.modes.put(mode.getIdentifier(), mode);
        mode.setPerspective(this.perspective);
    }

    public LocationModePerspective getMode(ExtendedMode mode) {
        return this.modes.get(mode);
    }

    public ExtendedMode[] getModes() {
        return this.modes.keySet().toArray(new ExtendedMode[this.modes.size()]);
    }

    public ExtendedMode getMode(PerspectiveDockable dockable) {
        while (dockable != null) {
            for (LocationModePerspective mode : this.modes.values()) {
                if (!mode.isCurrentMode(dockable)) continue;
                return mode.getIdentifier();
            }
            PerspectiveStation parent = dockable.getParent();
            dockable = parent == null ? null : parent.asDockable();
        }
        return null;
    }

    public CStationPerspective getRoot(PerspectiveDockable dockable) {
        while (dockable != null) {
            CStationPerspective station;
            PerspectiveStation parent = dockable.getParent();
            if (parent == null) {
                return null;
            }
            if (parent instanceof CommonElementPerspective && this.perspective.getRoot((station = ((CommonElementPerspective)((Object)parent)).getElement().asStation()).getUniqueId()) != null) {
                return station;
            }
            dockable = parent.asDockable();
        }
        return null;
    }

    public Location getLocation(CDockablePerspective dockable) {
        return this.getLocation(dockable.intern().asDockable());
    }

    public Location getLocation(PerspectiveDockable dockable) {
        CStationPerspective root = this.getRoot(dockable);
        if (root == null) {
            return null;
        }
        ExtendedMode mode = this.getMode(dockable);
        if (mode == null) {
            return null;
        }
        DockableProperty location = DockUtilities.getPropertyChain(root.intern().asStation(), dockable);
        if (location == null) {
            return null;
        }
        return new Location(mode.getModeIdentifier(), root.getUniqueId(), location);
    }

    public ModeSettings<Location, ?> writeModes(CControlAccess control) {
        CLocationModeSettings<Location> modes = new CLocationModeSettings<Location>(new LocationSettingConverter());
        LocationModeManagerPerspective manager = this.perspective.getLocationManager();
        Iterator<PerspectiveElement> elements = this.perspective.elements();
        while (elements.hasNext()) {
            CDockablePerspective dockable;
            PerspectiveElement next = elements.next();
            if (!(next instanceof CommonElementPerspective) || (dockable = ((CommonElementPerspective)next).getElement().asDockable()) == null) continue;
            String id = null;
            if (dockable instanceof SingleCDockablePerspective) {
                id = control.getRegister().toSingleId(((SingleCDockablePerspective)dockable).getUniqueId());
            } else if (dockable instanceof MultipleCDockablePerspective) {
                id = ((MultipleCDockablePerspective)dockable).getUniqueId();
                if (id != null) {
                    id = control.getRegister().toMultiId(id);
                } else {
                    throw new IllegalStateException("detected dockable with no identifier");
                }
            }
            if (id == null) continue;
            ExtendedMode current = manager.getMode(dockable.intern().asDockable());
            LocationHistory history = dockable.getLocationHistory();
            List<Path> order = history.getOrder();
            Map<Path, Location> locations = history.getLocations();
            modes.add(id, current == null ? null : current.getModeIdentifier(), locations, order);
        }
        for (ExtendedMode mode : manager.getModes()) {
            ModeSettingFactory<Location> factory = this.settingFactories.get(mode.getModeIdentifier());
            if (factory == null) continue;
            ModeSetting<Location> setting = factory.create();
            this.getMode(mode).writeSetting(setting);
            modes.add(setting);
        }
        return modes;
    }

    public void readModes(ModeSettings<Location, ?> modes, CPerspective cperspective, CControlAccess control) {
        Iterator<PerspectiveElement> elements = cperspective.elements();
        while (elements.hasNext()) {
            int index;
            CDockablePerspective dockable;
            PerspectiveElement next = elements.next();
            if (!(next instanceof CommonElementPerspective) || (dockable = ((CommonElementPerspective)next).getElement().asDockable()) == null) continue;
            String id = null;
            if (dockable instanceof SingleCDockablePerspective) {
                id = ((SingleCDockablePerspective)dockable).getUniqueId();
                id = control.getRegister().toSingleId(id);
            } else if (dockable instanceof MultipleCDockablePerspective) {
                id = ((MultipleCDockablePerspective)dockable).getUniqueId();
                id = control.getRegister().toMultiId(id);
            }
            if (id == null || (index = modes.indexOf(id)) == -1) continue;
            Path[] order = modes.getHistory(index);
            Map<Path, Location> locations = modes.getProperties(index);
            LocationHistory history = dockable.getLocationHistory();
            for (Path item : order) {
                ExtendedMode mode = this.getMode(item);
                if (mode == null) {
                    throw new IllegalStateException("unknown ExtendedMode with id='" + item + "'");
                }
                history.add(mode, locations.get(item));
            }
        }
        for (ExtendedMode mode : this.getModes()) {
            ModeSetting<Location> modeSetting = modes.getSettings(mode.getModeIdentifier());
            if (modeSetting == null) continue;
            this.getMode(mode).readSetting(modeSetting);
        }
    }
}

