/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentListener;
import bibliothek.gui.dock.util.PropertyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ButtonContentValue
extends PropertyValue<ButtonContent>
implements ButtonContentListener {
    private Dockable dockable;
    private ButtonContent theme;
    private boolean showKnob;
    private boolean showIcon;
    private boolean showText;
    private boolean showChildren;
    private boolean showActions;
    private boolean filterActions;

    public ButtonContentValue(ButtonContent theme) {
        super(FlapDockStation.BUTTON_CONTENT);
        this.theme = theme;
    }

    @Override
    protected void valueChanged(ButtonContent oldValue, ButtonContent newValue) {
        if (this.dockable != null) {
            if (oldValue != null) {
                oldValue.removeListener(this.dockable, this);
            }
            if (newValue != null) {
                newValue.addListener(this.dockable, this);
            }
            this.checkProperties();
        }
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != dockable) {
            ButtonContent content = (ButtonContent)this.getValue();
            if (this.dockable != null) {
                this.theme.removeListener(dockable, this);
                if (content != null) {
                    content.removeListener(this.dockable, this);
                }
            }
            this.dockable = dockable;
            if (this.dockable != null) {
                this.theme.addListener(dockable, this);
                if (content != null) {
                    content.addListener(this.dockable, this);
                }
            }
            this.checkProperties();
        }
    }

    @Override
    public void changed(ButtonContent content, Dockable dockable) {
        if (this.dockable == dockable && this.getValue() == content) {
            this.checkProperties();
        }
    }

    private void checkProperties() {
        ButtonContent content = (ButtonContent)this.getValue();
        if (content != null && this.dockable != null) {
            boolean change = false;
            if (this.showKnob != content.showKnob(this.dockable, this.theme.showKnob(this.dockable, false))) {
                this.showKnob = !this.showKnob;
                change = true;
            }
            if (this.showIcon != content.showIcon(this.dockable, this.theme.showIcon(this.dockable, false))) {
                this.showIcon = !this.showIcon;
                change = true;
            }
            if (this.showText != content.showText(this.dockable, this.theme.showText(this.dockable, false))) {
                this.showText = !this.showText;
                change = true;
            }
            if (this.showChildren != content.showChildren(this.dockable, this.theme.showChildren(this.dockable, false))) {
                this.showChildren = !this.showChildren;
                change = true;
            }
            if (this.showActions != content.showActions(this.dockable, this.theme.showActions(this.dockable, false))) {
                this.showActions = !this.showActions;
                change = true;
            }
            if (this.filterActions != content.filterActions(this.dockable, this.theme.filterActions(this.dockable, false))) {
                this.filterActions = !this.filterActions;
                change = true;
            }
            if (change) {
                this.propertyChanged();
            }
        }
    }

    public boolean isShowKnob() {
        return this.showKnob;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public boolean isShowChildren() {
        return this.showChildren;
    }

    public boolean isShowActions() {
        return this.showActions;
    }

    public boolean isFilterActions() {
        return this.filterActions;
    }

    protected abstract void propertyChanged();
}

