/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.util.ArrayList;
import java.util.Arrays;

public final class Path {
    public static final Path TYPE_INT_PATH = new Path("java.lang.Integer");
    public static final Path TYPE_STRING_PATH = new Path("java.lang.String");
    public static final Path TYPE_BOOLEAN_PATH = new Path("java.lang.Boolean");
    public static final Path TYPE_KEYSTROKE_PATH = new Path("javax.swing.KeyStroke");
    public static final Path TYPE_MODIFIER_MASK_PATH = new Path("dock.modifier_mask");
    public static final Path TYPE_STRING_CHOICE_PATH = new Path("dock.choice");
    public static final Path TYPE_LABEL = new Path("dock.label");
    private String[] segments;

    public static String encodeSegment(String segment) {
        StringBuilder builder = new StringBuilder(segment.length());
        int n = segment.length();
        for (int i = 0; i < n; ++i) {
            char c = segment.charAt(i);
            boolean escape = false;
            if (c == '.') {
                escape = true;
            } else if (c == '\\') {
                escape = true;
            } else if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    escape = true;
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                escape = true;
            }
            if (escape) {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String decodeSegment(String segment) {
        StringBuilder builder = new StringBuilder(segment.length());
        boolean escape = false;
        int n = segment.length();
        for (int i = 0; i < n; ++i) {
            char c = segment.charAt(i);
            if (escape) {
                escape = false;
                builder.append(c);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean isValidPath(String path) {
        try {
            new Path(path);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public Path(String ... segments) {
        this.segments = new String[segments.length];
        System.arraycopy(segments, 0, this.segments, 0, segments.length);
        for (String check : this.segments) {
            if (check != null) continue;
            throw new IllegalArgumentException("null segments are not allowed");
        }
    }

    public Path() {
        this.segments = new String[0];
    }

    public Path(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        ArrayList<String> list = new ArrayList<String>();
        int lastDot = -1;
        boolean escape = false;
        int n = path.length();
        for (int i = 0; i <= n; ++i) {
            char c;
            if (i == n) {
                escape = false;
                c = '.';
            } else {
                c = path.charAt(i);
            }
            if (escape) {
                escape = false;
                continue;
            }
            if (c == '.') {
                if (lastDot + 1 == i) {
                    throw new IllegalArgumentException("not a path: empty segment");
                }
                list.add(Path.decodeSegment(path.substring(lastDot + 1, i)));
                lastDot = i;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (lastDot + 1 == i) {
                if (Character.isJavaIdentifierStart(c)) continue;
                throw new IllegalArgumentException("not a valid start of a segment: '" + c + "'");
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("not a valid character of a segment: '" + c + "'");
        }
        this.segments = list.toArray(new String[list.size()]);
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        return this.segments[index];
    }

    public String getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path subPath(int offset, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be at least 1: " + length);
        }
        String[] result = new String[length];
        System.arraycopy(this.segments, offset, result, 0, length);
        return new Path(result);
    }

    public Path append(Path path) {
        String[] segments = new String[this.segments.length + path.segments.length];
        System.arraycopy(this.segments, 0, segments, 0, this.segments.length);
        System.arraycopy(path.segments, 0, segments, this.segments.length, path.segments.length);
        return new Path(segments);
    }

    public Path uniqueAppend(Path path) {
        String[] segments = new String[this.segments.length + 2 + path.segments.length];
        segments[0] = "_f" + this.segments.length;
        System.arraycopy(this.segments, 0, segments, 1, this.segments.length);
        segments[this.segments.length + 1] = "_s" + path.segments.length;
        System.arraycopy(path.segments, 0, segments, this.segments.length + 2, path.segments.length);
        return new Path(segments);
    }

    public Path append(String segments) {
        return this.append(new Path(segments));
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] result = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, result, 0, result.length);
        return new Path(result);
    }

    public boolean startsWith(Path path) {
        if (path.getSegmentCount() > this.getSegmentCount()) {
            return false;
        }
        int n = path.getSegmentCount();
        for (int i = 0; i < n; ++i) {
            if (path.getSegment(i).equals(this.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.segments, other.segments);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append(".");
            }
            builder.append(Path.encodeSegment(this.segments[i]));
        }
        return builder.toString();
    }
}

