/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.AbstractTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public class EclipseTab
extends AbstractTab
implements CombinedTab {
    private TabComponent component;
    private EclipseTabPane parent;

    public EclipseTab(EclipseTabPane parent, Dockable dockable, TabComponent delegate) {
        super(parent, dockable);
        this.parent = parent;
        this.component = delegate;
        this.component.setIcon(dockable.getTitleIcon());
        this.component.setText(dockable.getTitleText());
        this.component.setTab(this);
    }

    public Component getComponent() {
        return this.component.getComponent();
    }

    public TabComponent getTabComponent() {
        return this.component;
    }

    public void setPaneVisible(boolean visible) {
        this.parent.getTabHandler().setVisible(this, visible);
    }

    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    public void setZOrder(int order) {
        this.parent.getTabHandler().setZOrder(this, order);
    }

    public int getZOrder() {
        return this.parent.getTabHandler().getZOrder(this);
    }

    public void setIcon(Icon icon) {
        this.component.setIcon(icon);
    }

    public void setText(String text) {
        this.component.setText(text);
    }

    public void setTooltip(String tooltip) {
        this.component.setTooltip(tooltip);
    }

    public void setOrientation(TabPlacement orientation) {
        super.setOrientation(orientation);
        this.component.setOrientation(orientation);
    }

    public void addMouseInputListener(MouseInputListener listener) {
        this.component.addMouseInputListener(listener);
    }

    public Dimension getMinimumSize(Tab[] tabs) {
        return this.component.getMinimumSize(this.extract(tabs));
    }

    public Dimension getPreferredSize(Tab[] tabs) {
        return this.component.getPreferredSize(this.extract(tabs));
    }

    private TabComponent[] extract(Tab[] tabs) {
        TabComponent[] components = new TabComponent[tabs.length];
        for (int i = 0; i < tabs.length; ++i) {
            if (!(tabs[i] instanceof EclipseTab)) continue;
            components[i] = ((EclipseTab)tabs[i]).getTabComponent();
        }
        return components;
    }

    public DockElement getElement() {
        return this.getDockable();
    }

    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public boolean shouldFocus() {
        return true;
    }

    public boolean shouldTransfersFocus() {
        return true;
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        this.component.removeMouseInputListener(listener);
    }

    public void bind() {
        this.component.bind();
        super.bind();
    }

    public void unbind() {
        this.component.unbind();
        super.unbind();
    }

    public Insets getOverlap(TabPaneComponent other) {
        if (other instanceof EclipseTab) {
            EclipseTab tab = (EclipseTab)other;
            return this.getTabComponent().getOverlap(tab.getTabComponent());
        }
        return super.getOverlap(other);
    }

    public void setPaintIconWhenInactive(boolean paint) {
        this.component.setPaintIconWhenInactive(paint);
    }

    protected void informFocusChanged(boolean focused) {
        this.component.setFocused(focused);
    }

    protected void informSelectionChanged(boolean selected) {
        this.component.setSelected(selected);
    }

    public String toString() {
        Dockable dockable = this.component.getElement().asDockable();
        if (dockable == null) {
            return this.getClass().getSimpleName() + "@[component=" + this.component + "]";
        }
        return this.getClass().getSimpleName() + "@[dockable title=" + dockable.getTitleText() + "]";
    }
}

