/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleBackgroundComponent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.OrientationToRotationStrategy;
import bibliothek.gui.dock.title.OrientationToRotationStrategyListener;
import bibliothek.gui.dock.title.TitleDockBorder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDockTitle
extends BackgroundPanel
implements DockTitle {
    private static final Insets DEFAULT_INSETS_HORIZONTAL = new Insets(0, 1, 0, 1);
    private static final Insets DEFAULT_INSETS_VERTICAL = new Insets(1, 0, 1, 0);
    private Dockable dockable;
    private OrientedLabel label = new OrientedLabel(){

        protected void updateFonts() {
            AbstractDockTitle.this.updateFonts();
        }
    };
    private ButtonPanel itemPanel;
    private Listener listener = new Listener();
    private DockTitleVersion origin;
    private boolean active = false;
    private boolean bound = false;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Icon icon;
    private int iconTextGap = 0;
    private List<AbstractDockColor> colors = new ArrayList<AbstractDockColor>();
    private List<AbstractDockFont> fonts = new ArrayList<AbstractDockFont>();
    private List<ConditionalFont> conditionalFonts;
    private Background background = new Background();
    private TitleBorder border;
    private PropertyValue<OrientationToRotationStrategy> orientationConverter = new PropertyValue<OrientationToRotationStrategy>(DockTitle.ORIENTATION_STRATEGY){

        @Override
        protected void valueChanged(OrientationToRotationStrategy oldValue, OrientationToRotationStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeListener(AbstractDockTitle.this.orientationListener);
                oldValue.uninstall(AbstractDockTitle.this);
            }
            if (newValue != null) {
                newValue.install(AbstractDockTitle.this);
                newValue.addListener(AbstractDockTitle.this.orientationListener);
            }
            AbstractDockTitle.this.updateLabelRotation();
        }
    };
    private OrientationToRotationStrategyListener orientationListener = new OrientationToRotationStrategyListener(){

        public void rotationChanged(Dockable dockable, DockTitle title) {
            if (!(title != AbstractDockTitle.this && title != null || dockable != AbstractDockTitle.this.dockable && dockable != null)) {
                AbstractDockTitle.this.updateLabelRotation();
            }
        }
    };

    public AbstractDockTitle(Dockable dockable, DockTitleVersion origin) {
        this(dockable, origin, true);
    }

    public AbstractDockTitle(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        super(true, false);
        this.init(dockable, origin, showMiniButtons);
    }

    protected AbstractDockTitle() {
        super(true, false);
    }

    protected void init(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        this.dockable = dockable;
        this.origin = origin;
        this.label.setBackground(this.background);
        this.setBackground(this.background);
        this.setLayout(null);
        this.add(this.label);
        this.setActive(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                return component != AbstractDockTitle.this && super.accept(component);
            }
        });
        this.setOpaque(false);
        this.setShowMiniButtons(showMiniButtons);
    }

    public boolean isShowMiniButtons() {
        return this.itemPanel != null;
    }

    public void setShowMiniButtons(boolean showMiniButtons) {
        if (showMiniButtons) {
            if (this.itemPanel == null) {
                this.itemPanel = new ButtonPanel(true){

                    @Override
                    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
                        return AbstractDockTitle.this.createItemFor(action, dockable);
                    }
                };
                this.itemPanel.setOpaque(false);
                this.itemPanel.setOrientation(this.getOrientation());
                this.itemPanel.setToolTipText(this.getToolTipText());
                this.add(this.itemPanel);
                if (this.isBound()) {
                    this.itemPanel.set(this.getDockable(), this.getActionSourceFor(this.getDockable()));
                }
            }
        } else if (this.itemPanel != null) {
            this.itemPanel.set(null);
            this.remove(this.itemPanel);
        }
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        this.revalidate();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    protected void addColor(AbstractDockColor color) {
        this.colors.add(color);
        if (this.bound) {
            color.connect(this.getDockable().getController());
        }
    }

    protected void removeColor(AbstractDockColor color) {
        this.colors.remove(color);
        color.connect(null);
    }

    protected void addFont(AbstractDockFont font) {
        this.fonts.add(font);
        if (this.bound) {
            font.connect(this.getDockable().getController());
        }
    }

    protected void removeFont(AbstractDockFont font) {
        this.fonts.remove(font);
        font.connect(null);
    }

    protected void addConditionalFont(String id, Path kind, Condition condition, FontModifier backup) {
        ConditionalFont font = new ConditionalFont(id, kind, condition, backup);
        this.addFont(font);
        if (this.conditionalFonts == null) {
            this.conditionalFonts = new ArrayList<ConditionalFont>();
        }
        this.conditionalFonts.add(font);
        this.updateFonts();
    }

    protected void removeAllConditionalFonts() {
        if (this.conditionalFonts != null) {
            for (ConditionalFont font : this.conditionalFonts) {
                this.removeFont(font);
            }
            this.conditionalFonts = null;
            this.updateFonts();
        }
    }

    public Rectangle getIconBounds() {
        if (this.icon == null) {
            return null;
        }
        Insets insets = this.titleInsets();
        if (this.orientation.isVertical()) {
            int width = this.getWidth() - insets.left - insets.right;
            return new Rectangle(insets.left + (width - this.icon.getIconWidth()) / 2, insets.top, this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        int height = this.getHeight() - insets.top - insets.bottom;
        return new Rectangle(insets.left, insets.top + (height - this.icon.getIconHeight()) / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    @Override
    public void paintBackground(Graphics g) {
        this.paintBackground(g, this);
    }

    protected void paintBackground(Graphics g, JComponent component) {
        g.setColor(component.getBackground());
        g.fillRect(0, 0, component.getWidth(), component.getHeight());
    }

    @Override
    public void paintForeground(Graphics g) {
        this.paintForeground(g, this);
    }

    protected void paintForeground(Graphics g, JComponent component) {
        if (this.icon != null) {
            Insets insets = this.titleInsets();
            if (this.orientation.isVertical()) {
                int width = this.getWidth() - insets.left - insets.right;
                this.icon.paintIcon(this, g, insets.left + (width - this.icon.getIconWidth()) / 2, insets.top);
            } else {
                int height = this.getHeight() - insets.top - insets.bottom;
                this.icon.paintIcon(this, g, insets.left, insets.top + (height - this.icon.getIconHeight()) / 2);
            }
        }
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
        this.revalidate();
        this.repaint();
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void setText(String text) {
        this.label.setText(text);
        this.repaint();
    }

    protected String getText() {
        return this.label.getText();
    }

    protected void setTooltip(String text) {
        this.setToolTipText(text);
        this.label.setToolTipText(text);
        if (this.itemPanel != null) {
            this.itemPanel.setToolTipText(text);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.orientation = orientation;
        if (this.itemPanel != null) {
            this.itemPanel.setOrientation(orientation);
        }
        this.updateLabelRotation();
        this.revalidate();
    }

    private void updateLabelRotation() {
        this.label.setRotation(this.orientationConverter.getValue().convert(this.getOrientation(), this));
    }

    @Override
    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public DockTitleVersion getOrigin() {
        return this.origin;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color fg) {
        super.setBackground(fg);
        if (this.label != null) {
            this.label.setBackground(fg);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setFontModifier(FontModifier modifier) {
        this.label.setFontModifier(modifier);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        Dimension preferred = this.getPreferredSize();
        int min = Math.min(preferred.width, preferred.height);
        return new Dimension(min, min);
    }

    public void setBorder(String key, Border border) {
        if (!(this.border == null || key != null && this.border.id.equals(key))) {
            this.border.setController(null);
            this.border = null;
        }
        if (this.border == null && key != null) {
            this.border = new TitleBorder(key);
            if (this.bound) {
                this.border.setController(this.getOrigin().getController());
            }
        }
        if (this.border == null) {
            this.setBorder(border);
        } else {
            this.border.setBorder(border);
        }
    }

    protected Insets getInnerInsets() {
        if (this.getOrientation().isHorizontal()) {
            return DEFAULT_INSETS_HORIZONTAL;
        }
        return DEFAULT_INSETS_VERTICAL;
    }

    private Insets titleInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return this.getInnerInsets();
        }
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        Insets inner = this.getInnerInsets();
        insets.top += inner.top;
        insets.bottom += inner.bottom;
        insets.left += inner.left;
        insets.right += inner.right;
        return insets;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Insets insets = this.titleInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        String text = this.getText();
        Dimension labelPreferred = text == null || text.length() == 0 ? new Dimension(5, 5) : this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            if (this.icon != null) {
                x += this.icon.getIconWidth() + this.iconTextGap;
                width -= this.icon.getIconWidth() + this.iconTextGap;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                int count;
                Dimension[] buttonPreferred = this.itemPanel.getPreferredSizes();
                int remaining = width - labelPreferred.width;
                for (count = buttonPreferred.length - 1; count > 0 && buttonPreferred[count].width > remaining; --count) {
                }
                this.itemPanel.setVisibleActions(count);
                int buttonWidth = buttonPreferred[count].width;
                int buttonX = width - buttonWidth;
                this.label.setBounds(x, y, buttonX, height);
                this.itemPanel.setBounds(x + buttonX, y, width - buttonX, height);
            } else {
                this.label.setBounds(x, y, width, height);
            }
        } else {
            if (this.icon != null) {
                y += this.icon.getIconWidth() + this.iconTextGap;
                height -= this.icon.getIconWidth() + this.iconTextGap;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                int count;
                Dimension[] buttonPreferred = this.itemPanel.getPreferredSizes();
                int remaining = height - labelPreferred.height;
                for (count = buttonPreferred.length - 1; count > 0 && buttonPreferred[count].height > remaining; --count) {
                }
                this.itemPanel.setVisibleActions(count);
                int buttonHeight = buttonPreferred[count].height;
                int buttonY = height - buttonHeight;
                this.label.setBounds(x, y, width, buttonY);
                this.itemPanel.setBounds(x, y + buttonY, width, height - buttonY);
            } else {
                this.label.setBounds(x, y, width, height);
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.label.addMouseListener(listener);
        this.label.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
        this.label.removeMouseListener(listener);
        this.label.removeMouseMotionListener(listener);
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        boolean restrained = this.getText() == null || this.getText().length() == 0;
        Rectangle icon = this.getIconBounds();
        if (icon != null && icon.contains(click)) {
            if (restrained) {
                int size = this.getWidth() * this.getHeight();
                if (this.itemPanel != null) {
                    size -= this.itemPanel.getWidth() * this.itemPanel.getHeight();
                }
                if (size <= 2 * icon.width * icon.height) {
                    return null;
                }
            }
            if (this.getOrientation().isHorizontal()) {
                return new Point(icon.x, icon.y + icon.height);
            }
            return new Point(icon.x + icon.width, icon.y);
        }
        return null;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void changed(DockTitleEvent event) {
        this.setActive(event.isActive());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = this.getText() == null || this.getText().length() == 0 ? new Dimension(5, 5) : this.label.getPreferredSize();
        Insets insets = this.titleInsets();
        if (this.orientation.isHorizontal()) {
            int width = 0;
            int height = 0;
            if (this.icon != null) {
                width = this.icon.getIconWidth();
                height = this.icon.getIconHeight();
            }
            height = Math.max(height, preferred.height);
            width += preferred.width;
            if (this.itemPanel != null) {
                Dimension items = this.itemPanel.getPreferredSize();
                height = Math.max(height, items.height);
                width += items.width;
            }
            if (this.icon == null) {
                width = Math.max(width, 2 * height);
            }
            preferred = new Dimension(width + this.iconTextGap + insets.left + insets.right, height + insets.top + insets.bottom);
        } else {
            int width = 0;
            int height = 0;
            if (this.icon != null) {
                width = this.icon.getIconWidth();
                height = this.icon.getIconHeight();
            }
            width = Math.max(width, preferred.width);
            height += preferred.height;
            if (this.itemPanel != null) {
                Dimension items = this.itemPanel.getPreferredSize();
                width = Math.max(width, items.width);
                height += items.height;
            }
            if (this.icon == null) {
                height = Math.max(height, 2 * width);
            }
            preferred = new Dimension(width + insets.left + insets.right, height + this.iconTextGap + insets.top + insets.bottom);
        }
        if (preferred.width < 10) {
            preferred.width = 10;
        }
        if (preferred.height < 10) {
            preferred.height = 10;
        }
        return preferred;
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(action, ViewTarget.TITLE, dockable);
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return dockable.getGlobalActionOffers();
    }

    @Override
    public void bind() {
        if (this.bound) {
            throw new IllegalArgumentException("Do not call bound twice!");
        }
        this.bound = true;
        if (this.itemPanel != null) {
            this.itemPanel.set(this.dockable, this.getActionSourceFor(this.dockable));
        }
        this.dockable.addDockableListener(this.listener);
        DockController controller = this.getDockable().getController();
        if (controller != null) {
            for (AbstractDockColor color : this.colors) {
                color.connect(controller);
            }
            for (AbstractDockFont font : this.fonts) {
                font.connect(controller);
            }
            this.orientationConverter.setProperties(controller);
        }
        this.background.setController(controller);
        if (this.border != null) {
            this.border.setController(controller);
        }
        this.updateText();
        this.updateIcon();
        this.updateTooltip();
        this.revalidate();
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            throw new IllegalArgumentException("Do not call unbind twice");
        }
        this.bound = false;
        this.dockable.removeDockableListener(this.listener);
        if (this.itemPanel != null) {
            this.itemPanel.set(null);
        }
        for (AbstractDockColor color : this.colors) {
            color.connect(null);
        }
        for (AbstractDockFont font : this.fonts) {
            font.connect(null);
        }
        this.orientationConverter.setProperties((DockProperties)null);
        if (this.border != null) {
            this.border.setController(null);
        }
        this.setText("");
        this.setIcon(null);
        this.setTooltip(null);
        this.background.setController(null);
    }

    protected void updateIcon() {
        this.setIcon(this.dockable.getTitleIcon());
    }

    protected void updateText() {
        this.setText(this.dockable.getTitleText());
    }

    protected void updateTooltip() {
        this.setTooltip(this.dockable.getTitleToolTip());
    }

    public boolean isBound() {
        return this.bound;
    }

    protected void updateFonts() {
        if (this.conditionalFonts != null) {
            FontModifier modifier = null;
            for (ConditionalFont font : this.conditionalFonts) {
                if (!font.getState()) continue;
                modifier = (FontModifier)font.value();
                break;
            }
            this.setFontModifier(modifier);
        }
    }

    private class TitleBorder
    implements TitleDockBorder {
        private String id;
        private BorderModifier modifier;
        private DockController controller;
        private Border border;

        public TitleBorder(String id) {
            this.id = id;
        }

        public DockTitle getTitle() {
            return AbstractDockTitle.this;
        }

        public void set(BorderModifier value) {
            if (value != this.modifier) {
                this.modifier = value;
                this.update();
            }
        }

        public void setBorder(Border border) {
            if (this.border != border) {
                this.border = border;
                this.update();
            }
        }

        private void update() {
            if (this.modifier == null) {
                AbstractDockTitle.this.setBorder(this.border);
            } else {
                AbstractDockTitle.this.setBorder(this.modifier.modify(this.border));
            }
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getThemeManager().remove(this);
            }
            this.controller = controller;
            if (this.controller == null) {
                this.set(null);
            } else {
                this.controller.getThemeManager().add(this.id, TitleDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockTitleBackgroundComponent {
        public Background() {
            super(DockTitleBackgroundComponent.KIND, "dock.background.title");
        }

        public DockTitle getTitle() {
            return AbstractDockTitle.this;
        }

        public Component getComponent() {
            return this.getTitle().getComponent();
        }
    }

    private class Listener
    implements DockableListener,
    DockHierarchyListener {
        private Listener() {
        }

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            AbstractDockTitle.this.updateIcon();
            AbstractDockTitle.this.updateText();
        }

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            AbstractDockTitle.this.updateIcon();
            AbstractDockTitle.this.updateText();
        }

        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            AbstractDockTitle.this.updateTooltip();
        }

        public void titleUnbound(Dockable dockable, DockTitle title) {
        }

        public void titleBound(Dockable dockable, DockTitle title) {
        }

        public void titleExchanged(Dockable dockable, DockTitle title) {
        }

        public void controllerChanged(DockHierarchyEvent event) {
            DockController controller = event.getDockable().getController();
            for (AbstractDockColor color : AbstractDockTitle.this.colors) {
                color.connect(controller);
            }
        }

        public void hierarchyChanged(DockHierarchyEvent event) {
        }
    }

    private class ConditionalFont
    extends TitleFont {
        private Condition condition;

        public ConditionalFont(String id, Path kind, Condition condition, FontModifier backup) {
            super(id, AbstractDockTitle.this, kind, backup);
            this.condition = condition;
        }

        public boolean getState() {
            return this.condition.getState();
        }

        protected void changed(FontModifier oldValue, FontModifier newValue) {
            AbstractDockTitle.this.updateFonts();
        }
    }
}

