% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_spew.R
\name{summarize_spew_out}
\alias{summarize_spew_out}
\title{Summarize spew output}
\usage{
summarize_spew_out(syneco = NULL, vars_to_sum_h, vars_to_sum_p,
  vars_to_sum_env = NULL, samp_size = 10^4, type = "US",
  summary_level = 2, marginals = NULL, output_dir = NULL,
  top_region_id = NULL, has_marg = FALSE)
}
\arguments{
\item{syneco}{output from the 'spew' function}

\item{vars_to_sum_h}{character vector of variables from the household data frame output to summarize}

\item{vars_to_sum_p}{character vector of variables from the person data frame output to summarize}

\item{vars_to_sum_env}{character vector of variables from the person data frame which correspond to environment assignments.  Default is NULL.}

\item{samp_size}{number of agents to retain from each lower-level region, for plotting purposes only.  Default is 10^4.}

\item{type}{Only used when output_dir is specified."US" for a US population, "IPUMS" for IPUMS population, or "custom" for a custom population.  This effects what the summary levels are.}

\item{summary_level}{Only used when output_dir is specified.  IFor the US, 1-state, 2-county, 3-tract.  For IPUMS, 1 -country, 2-province.  For "custom," these are defined by the user's input data.}

\item{marginals}{list containing all of the marginal totals.  See ?make_ipf_marg for more details.}

\item{output_dir}{path to top level directory of SPEW folders.  Ex. "./10" for Delaware.  Default is NULL.  In the case it is NULL, we do not need to read in data.}

\item{top_region_id}{name of the region.  Default is NULL.  It is only used in the case where we directly summarize the syneco object.}

\item{has_marg}{Does the region of marginals to refer to?  Logical.  Default is FALSE.}
}
\value{
list with the household summary list, people summary list, header for households, and header 
for people, and a data frame of plotting coordinates by summary region
}
\description{
Summarize spew output
}
\note{
This function is only guaranteed to work when you provide marginals describing how a category is "cut."  If a certain category is not represented, then the final totals in each category may be off.
}
\examples{
data(tartanville)

tartanville_syneco <- spew(tartanville$pop_table, tartanville$shapefile, 
                           tartanville$pums_h, tartanville$pums_p)
                           
out <-  summarize_spew_out(tartanville_syneco, 
                           vars_to_sum_h = c("puma_id"), 
                           vars_to_sum_p = c("SEX"), 
                           vars_to_sum_env = NULL, 
                           top_region_id = "Tartanville") 
print(out)

}
