% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spnorm01}
\alias{spnorm01}
\title{Normalizes the Absorbance Between 0 and 1 of a Matrix of Mid-infrared Spectra}
\usage{
spnorm01(spectra)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}
}
\value{
A matrix spectra normalized between 0 and 1. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
Allows the normalization of the absorbance values between 0 and 1 of a matrix of mid-infrared spectra.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Normalized spectra between 0 and 1
norm <- spnorm01(spectra=spectra)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

