% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracing.R
\name{get_trace}
\alias{get_trace}
\title{Tracing the index over an interpolated planned tour path.}
\usage{
get_trace(d, m, index_list, index_labels)
}
\arguments{
\item{d}{data}

\item{m}{list of projection matrices for the planned tour}

\item{index_list}{list of index functions to calculate for each entry}

\item{index_labels}{labels used in the output}
}
\value{
index values for each interpolation step
}
\description{
Tracing is used to test if the index value varies smoothly
over an interpolated tour path. The index value is calculated
for the data d in each projection in the interpolated sequence.
Note that all index functions must take the data in 2-d matrix
format and return the index value.
}
\examples{
d <- spiral_data(100, 4)
m <- list(basis_matrix(1,2,4), basis_matrix(3,4,4))
index_list <- list(tourr::holes(), tourr::cmass())
index_labels <- c("holes", "cmass")
trace <- get_trace(d, m, index_list, index_labels)
plot_trace(trace)
}
