% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_noise_threshold.R
\name{ppi_noise_threshold}
\alias{ppi_noise_threshold}
\title{Estimate the 95th Percentile of a Projection Pursuit Index Under Noise}
\usage{
ppi_noise_threshold(
  index_fun,
  n_sim = 100,
  n_obs = 500,
  noise_type = "gaussian",
  noise_level = 0.01,
  seed = NULL
)
}
\arguments{
\item{index_fun}{A function that takes either a 2-column matrix or two numeric vectors and returns a scalar index.}

\item{n_sim}{Integer. Number of index evaluations to simulate. Default is 100.}

\item{n_obs}{Integer. Number of observations per noise sample. Default is 500.}

\item{noise_type}{Character. Type of noise to use (e.g., "gaussian", "t_distributed", etc.). Default is "gaussian".}

\item{noise_level}{Numeric. Controls the scale/spread of the generated noise. Default is 0.01.}

\item{seed}{Optional integer. Random seed for reproducibility.}
}
\value{
A single numeric value: the estimated 95th percentile of the index under noise.
}
\description{
This function estimates the 95th percentile of a projection pursuit index
under synthetic noise data.
}
\examples{
ppi_noise_threshold(
  index_fun = scag_index("stringy"),
  noise_type = "cauchy",
  noise_level = 0.1,
  n_sim = 10,
  n_obs = 100
)

}
