% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.r
\name{splash_add_lua}
\alias{splash_add_lua}
\title{Add raw lua code into DSL call chain}
\usage{
splash_add_lua(splash_obj, lua_code)
}
\arguments{
\item{splash_obj}{splashr object}

\item{lua_code}{length 1 character vector of raw \code{lua} code}
}
\description{
The \code{splashr} \code{lua} DSL (domain specific language) wrapper wraps what the package
author believes to be the most common/useful \code{lua} functions. Users of the package
may have need to insert some custom \code{lua} code within a DSL call chain they are
building. You can insert any Splash \code{lua} code you like with this function call.
}
\details{
The code is inserted at the position the \code{splash_add_lua}() is called in the chain
which will be within the main "splash' function which is defined as:\preformatted{function main(splash)
  ...
end
}

If you need more flexibility, use the \code{\link[=execute_lua]{execute_lua()}} function.
}
\seealso{
Other splash_dsl_functions: \code{\link{splash_click}},
  \code{\link{splash_focus}}, \code{\link{splash_go}},
  \code{\link{splash_har_reset}}, \code{\link{splash_har}},
  \code{\link{splash_html}}, \code{\link{splash_png}},
  \code{\link{splash_press}}, \code{\link{splash_release}},
  \code{\link{splash_send_keys}},
  \code{\link{splash_send_text}}, \code{\link{splash_wait}}
}
\concept{splash_dsl_functions}
