% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getanID}
\alias{getanID}
\title{Add an "id" Variable to a Dataset}
\usage{
getanID(data, id.vars = NULL)
}
\arguments{
\item{data}{The input \code{data.frame} or \code{data.table}.}

\item{id.vars}{The variables that should be treated as ID variables. Defaults to \code{NULL}, at which point all variables are used to create the new ID variable.}
}
\value{
The input dataset (as a \code{data.table}) if ID variables are unique, or the input dataset with a new column named "\code{.id}".
}
\description{
Many functions will not work properly if there are duplicated ID variables
in a dataset. This function is a convenience function for \code{.N} from the "data.table" package to create an "\code{.id}"
variable that when used in conjunction with the existing ID variables,
should be unique.
}
\examples{
mydf <- data.frame(IDA = c("a", "a", "a", "b", "b"),
                   IDB = c(1, 1, 1, 1, 1), values = 1:5)
mydf
getanID(mydf, c("IDA", "IDB"))

mydf <- data.frame(IDA = c("a", "a", "a", "b", "b"),
                   IDB = c(1, 2, 1, 1, 2), values = 1:5)
mydf
getanID(mydf, 1:2)

\dontshow{rm(mydf)}
}
\author{
Ananda Mahto
}

