% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glances.R
\name{glances}
\alias{glances}
\title{Glance at many fitted model objects}
\usage{
glances(object, ..., sort_by = "AICc", decreasing = FALSE)
}
\arguments{
\item{object}{Fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Additional fitted model objects from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}. Ignored
if \code{object} has class \code{spmod_list}.}

\item{sort_by}{Sort by a \code{glance} statistic (i.e., the name of a column
output from \code{\link[=glance.spmod]{glance.spmod()}} or the order of model input (\code{sort_by = "order"}).
The default is \code{"AICc"}.}

\item{decreasing}{Should \code{sort_by} be decreasing or not? The default is \code{FALSE}.}
}
\value{
A tibble where each row represents the output of \code{glance()} for
each fitted model object.
}
\description{
\code{glances()} repeatedly calls \code{glance()} on several
fitted model objects and binds the output together, sorted by a column of interest.
}
\examples{
lmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "none"
)
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
glances(lmod, spmod)
glances(lmod, spmod, sort_by = "logLik", decreasing = TRUE)
}
