% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.spmodel}
\alias{logLik.spmodel}
\alias{logLik.splm}
\alias{logLik.spautor}
\title{Extract log-likelihood}
\usage{
\method{logLik}{splm}(object, ...)

\method{logLik}{spautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}} where \code{estmethod}
is \code{"ml"} or \code{"reml"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The log-likelihood.
}
\description{
Find the log-likelihood of a fitted model when \code{estmethod}
is \code{"ml"} or \code{"reml"}.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
logLik(spmod)
}
