% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-soccer.R
\name{geom_soccer}
\alias{geom_soccer}
\title{Generate a \code{ggplot2} instance containing a soccer pitch for a specified
league}
\usage{
geom_soccer(
  league,
  display_range = "full",
  pitch_updates = list(),
  color_updates = list(),
  rotation = 0,
  x_trans = 0,
  y_trans = 0,
  pitch_units = NULL,
  xlims = NULL,
  ylims = NULL
)
}
\arguments{
\item{league}{The league for which to draw the surface. This is
case-insensitive}

\item{display_range}{A case-insensitive string indicating the display range
to use for the plot. The default is \code{"full"}, which will be returned
when either an invalid or no value is passed to the function.

The possible display ranges are:

\describe{
\item{\code{"full"}}{The full pitch. This is the default}
\item{\code{"in_bounds_only"}}{The full in-bounds area of the pitch}
\item{\code{"in bounds only"}}{The full in-bounds area of the pitch}
\item{\code{"offense"}}{The TV-right half of the pitch}
\item{\code{"offence"}}{The TV-right half of the pitch}
\item{\code{"offensivehalfpitch"}}{The TV-right half of the pitch}
\item{\code{"offensive_half_pitch"}}{The TV-right half of the pitch}
\item{\code{"offensive half pitch"}}{The TV-right half of the pitch}
\item{\code{"defense"}}{The TV-left half of the pitch}
\item{\code{"defence"}}{The TV-left half of the pitch}
\item{\code{"defensivehalfpitch"}}{The TV-left half of the pitch}
\item{\code{"defensive_half_pitch"}}{The TV-left half of the pitch}
\item{\code{"defensive half pitch"}}{The TV-left half of the pitch}
}}

\item{pitch_updates}{A list of updates to the pitch's parameters. These will
overwrite the parameters of the league}

\item{color_updates}{A list of updates to the pitch's default colors, which
are set by \code{\link[=soccer_features_set_colors]{soccer_features_set_colors()}}}

\item{rotation}{An angle, given in degrees, through which the plot should be
rotated}

\item{x_trans}{The amount that the \code{x} coordinates are to be shifted. By
convention, the +\code{x} axis extends from the center of the pitch towards
the right-hand goal when viewing the pitch in TV View}

\item{y_trans}{The amount that the \code{y} coordinates are to be shifted. By
convention, the +\code{y} axis extends from the center of the pitch towards
the top of the pitch when viewing the pitch in TV view}

\item{pitch_units}{The units with which to draw the pitch. The default is
\code{NULL}, which will apply the rule-book specified units}

\item{xlims}{The limits on the final display in the \code{x} direction. The
default is \code{NULL}, which will utilize the \code{xlims} specified by
the \code{display_range} parameter}

\item{ylims}{The limits on the final display in the \code{y} direction. The
default is \code{NULL}, which will utilize the \code{ylims} specified by
the \code{display_range} parameter}
}
\value{
A \code{ggplot2} instance with a full-surface representation of a
soccer pitch
}
\description{
Generate a \code{ggplot2} instance containing a soccer pitch for a specified
league
}
\examples{
\dontrun{
  geom_soccer(league = "EPL", rotation = 270, display_range = "offense")
  geom_soccer(league = "fifa", pitch_units = "ft")
}
}
