% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timeline.R
\name{plot_timeline}
\alias{plot_timeline}
\title{Plotting the timeline of the fire and the noise}
\usage{
plot_timeline(
  result,
  from = NULL,
  to = NULL,
  mainBreak = NULL,
  minorBreak = NULL,
  dateLabel = NULL
)
}
\arguments{
\item{result}{\code{spotoroo} object. A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{from}{\strong{OPTIONAL}. Date/Datetime/Numeric. Start time. The data type
needs to be the same as the provided observed time.}

\item{to}{\strong{OPTIONAL}. Date/Datetime/Numeric. End time. The data type
needs to be the same as the provided observed time.}

\item{mainBreak}{\strong{OPTIONAL}. Character/Numeric. A string/value giving the
difference between major breaks. If the
observed time is in date/datetime
format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_breaks}.}

\item{minorBreak}{\strong{OPTIONAL}. Character/Numeric. A string/value giving the
difference between minor breaks. If the
observed time is in date/datetime
format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_minor_breaks}.}

\item{dateLabel}{\strong{OPTIONAL}. Character. A string giving the formatting
specification for the labels. If the
observed
time is in date/datetime format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_labels}. Unavailable if the observed
time is in numeric format.}
}
\value{
A \code{ggplot} object. The plot of the timeline.
}
\description{
This function plots the timeline of the fires and the noise points.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)

  # Plot timeline
  plot_timeline(result,
              mainBreak = "1 week",
              minorBreak = "1 day",
              dateLabel = "\%b \%d")
}


}
