% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximations.R
\name{approx_normmix}
\alias{approx_normmix}
\title{Approximate the masses of bivariate normal mixture components}
\usage{
approx_normmix(mix, xlim = c(0, 1), ylim = c(0, 1))
}
\arguments{
\item{mix}{An object of class \code{normmix}}

\item{xlim, ylim}{Vectors defining the x-y integration limits. A mixture component mass is estimated within
this window.}
}
\value{
A numerical vector with elements corresponding to the mass of each component
within the window. These values are required when we
use truncation over an observation window in order to handle edge effects.
}
\description{
Calculates the mass of the density of each component of a normal mixture over a given window.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#approx_normmix}
}
\examples{

\dontrun{
truemix = normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2),
 c(.8, .8)), sigmas =list(.01*diag(2),.01*diag(2)))
summary(truemix)
approx_normmix(truemix,xlim= c(0, 1), ylim = c(0, 1))
approx_normmix(truemix,xlim= c(-2, 2), ylim = c(-2, 2))}

}
\author{
Jiaxun Chen, Yuchen Wang
}
\seealso{
\code{\link{normmix}}
}

