% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.springer.R
\name{cv.springer}
\alias{cv.springer}
\title{k-folds cross-validation for springer}
\usage{
cv.springer(
  clin = NULL,
  e,
  g,
  y,
  beta0,
  lambda1,
  lambda2,
  nfolds,
  func,
  corr,
  structure,
  maxits = 30,
  tol = 0.001
)
}
\arguments{
\item{clin}{a matrix of clinical covariates. The default value is NULL. Whether to include the clinical covariates is decided by user.}

\item{e}{a matrix of environment factors.}

\item{g}{a matrix of genetic factors.}

\item{y}{the longitudinal response.}

\item{beta0}{the initial value for the coefficient vector.}

\item{lambda1}{a user-supplied sequence of \eqn{\lambda_{1}} values, which serves as a tuning parameter for the individual-level penalty.}

\item{lambda2}{a user-supplied sequence of \eqn{\lambda_{2}} values, which serves as a tuning parameter for the group-level penalty.}

\item{nfolds}{the number of folds for cross-validation.}

\item{func}{the framework to obtain the score equation.  Two choices are available: "GEE" and "QIF".}

\item{corr}{the working correlation structure adopted in the estimation algorithm. The springer provides three choices for the
working correlation structure: exchangeable, AR-1,and independence.}

\item{structure}{Three choices are available for structured variable selection. "bilevel" for sparse-group selection on both group-level and individual-level. "group" for selection on group-level only. "individual" for selection on individual-level only.}

\item{maxits}{the maximum number of iterations that is used in the estimation algorithm. The default value is 30.}

\item{tol}{The tolerance level. Coefficients with absolute values that are smaller than the tolerance level will be set to zero. The adhoc value can be chosen as 0.001.}
}
\value{
an object of class "cv.springer" is returned, with is a list with components below:
\item{lam1}{the optimal \eqn{\lambda_{1}}.}
\item{lam2}{the optimal \eqn{\lambda_{2}}.}
}
\description{
This function conducts k-fold cross-validation for springer and returns the optimal values of the tuning parameters.
}
\details{
For bi-level sparse group selection, cv.springer returns two optimal tuning parameters,
\eqn{\lambda_{1}} and \eqn{\lambda_{2}}; for group-level selection, this function returns the optimal \eqn{\lambda_{2}} with \eqn{\lambda_{1}}=0;
for individual-level selection, this function returns the optimal \eqn{\lambda_{1}} with \eqn{\lambda_{2}}=0.
}
