% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsServerCollections.R
\name{incRv}
\alias{incRv}
\alias{multRv}
\alias{diviRv}
\title{In-line numeric operation for reactiveVal}
\usage{
incRv(react, value = 1)

multRv(react, value = 2)

diviRv(react, value = 2)
}
\arguments{
\item{react}{reactiveVal object, when it is called, should return an numeric object}

\item{value}{the numeric value to do the operation on \code{react}}
}
\value{
No return, will directly change the reactiveVal object provided to the
\code{react} argument
}
\description{
In-place operations like \verb{i += 1}, \verb{i -= 1} is not support in
R. These functions implement these operations in R. This set of functions will
apply this kind of operations on \verb{[shiny::reactiveVal]} objects.
}
\details{
\code{incRv(i)} is the same as \code{i <- i + 1}.
\code{incRv(i, -1)} is the same as \code{i <- i - 1}.
\code{multRv(i)} is the same as \code{i <- i * 2}.
\code{diviRv(i)} is the same as \code{i <- i / 2}.
}
\examples{
reactiveConsole(TRUE)
rv <- reactiveVal(0)
incRv(rv) # add 1
rv()
incRv(rv) # add 1
rv()
incRv(rv, -1) # minus 1
rv()
incRv(rv, -1) # minus 1
rv()
rv2 <- reactiveVal(1)
multRv(rv2) # times 2
rv2()
multRv(rv2) # times 2
rv2()
diviRv(rv2) # divide 2
rv2()
diviRv(rv2) # divide 2
rv2()
reactiveConsole(FALSE)
# Real shiny example
if(interactive()){
  ui <- fluidPage(
    textOutput("text"),
    actionButton("b", "increase by 1")
  )
  server <- function(input, output, session) {
    rv <- reactiveVal(0)
    observeEvent(input$b, {
      incRv(rv)
    })
    output$text <- renderText({
      rv()
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
If you want \link[shiny:reactiveValues]{shiny::reactiveValues}  version of these operators or just
normal numeric objects, use \link[spsUtil:inc]{spsUtil::inc}, \link[spsUtil:inc]{spsUtil::mult}, and \link[spsUtil:inc]{spsUtil::divi}.
}
