% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-kmeans.R
\name{kmeans_qts}
\alias{kmeans_qts}
\title{QTS K-Means Alignment Algorithm}
\usage{
kmeans_qts(
  x,
  k = 1,
  centroid = "mean",
  dissimilarity = "l2",
  warping = "affine",
  iter_max = 20,
  nstart = 1000,
  ncores = 1L
)
}
\arguments{
\item{x}{An object of class \link{qts_sample}.}

\item{k}{An integer specifying the number of clusters to be formed. Defaults
to \code{1L}.}

\item{centroid}{A string specifying which type of centroid should be used.
Choices are \code{mean} and \code{medoid}. Defaults to \code{mean}.}

\item{dissimilarity}{A string specifying which type of dissimilarity should
be used. Choices are \code{l2} and \code{pearson}. Defaults to \code{l2}.}

\item{warping}{A string specifying which class of warping functions should be
used. Choices are \code{none}, \code{shift}, \code{dilation} and \code{affine}. Defaults to
\code{affine}.}

\item{iter_max}{An integer specifying the maximum number of iterations for
terminating the k-mean algorithm. Defaults to \code{20L}.}

\item{nstart}{An integer specifying the number of random restart for making
the k-mean results more robust. Defaults to \code{1000L}.}

\item{ncores}{An integer specifying the number of cores to run the multiple
restarts of the k-mean algorithm in parallel. Defaults to \code{1L}.}
}
\value{
An object of class \code{kma_qts} which is effectively a list with three
components:
\itemize{
\item \code{qts_aligned}: An object of class \link{qts_sample} storing the sample of
aligned QTS;
\item \code{qts_centers}: A list of objects of class \link{qts} representing the centers of
the clusters;
\item \code{best_kma_result}: An object of class \link[fdacluster:kma]{fdacluster::kma} storing the results
of the best k-mean alignment result among all initialization that were tried.
}
}
\description{
This function massages the input quaternion time series to feed them into the
k-means alignment algorithm for jointly clustering and aligning the input
QTS.
}
\examples{
res_kma <- kmeans_qts(vespa64$igp, k = 2, nstart = 1)
}
