% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{sship_keygen}
\alias{sship_keygen}
\title{Make private-public key pair}
\usage{
sship_keygen(
  directory = normalizePath("~/.ssh"),
  type = "rsa",
  password = NULL
)
}
\arguments{
\item{directory}{Character string with path to directory where the key pair
will be written. Default is \code{normalizePath("~/.ssh")}}

\item{type}{Character string defining the key type. Must be one of "rsa"
(default) or "dsa". Key lengths are set to the default as defined in the
\emph{openssl}-package, currently 2048 and 1024, respectively}

\item{password}{Character string with password to protect the private key.
Default value is NULL in which case the private key will not be protected
by a password}
}
\value{
Nothing will be returned from this function, but a message containing
the directory where the keys were written is provided
}
\description{
Just for the convenience of it, make a key pair that may be used alongside
sship. Please note that by default the private key will not be protected by
a password.
}
\examples{
sship_keygen(directory = tempdir())
}
