% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.power.R
\name{check.power}
\alias{check.power}
\title{Average Power and True FDR Based on limma/voom RNAseq Analysis Pipeline}
\usage{
check.power(nGenes = 10000, pi0 = 0.8, m, mu, disp, fc, up = 0.5,
  replace = TRUE, fdr = 0.05, sims = 100)
}
\arguments{
\item{nGenes}{total number of genes, the default value is \code{10000}.}

\item{pi0}{proportion of non-differentially expressed genes, 
the default value is \code{0.8}.}

\item{m}{sample size per treatment group.}

\item{mu}{a vector (or scalar) of mean counts in control group 
from which to simulate.}

\item{disp}{a vector (or scalar) of dispersion parameter 
from which to simulate.}

\item{fc}{a vector (or scalar, or a function that takes an integer n 
          and generates a vector of length n)
of fold change for differentially expressed (DE) genes.}

\item{up}{proportion of up-regulated genes among all DE genes, 
the default value is \code{0.5}.}

\item{replace}{sample with or without replacement from given parameters. 
See Details for more information.}

\item{fdr}{the false discovery rate to be controlled.}

\item{sims}{number of simulations to run when computing power and FDR.}
}
\value{
\item{pow_bh_ave}{average power when controlling FDR 
                          by Benjamini and Hochberg (1995) method.}

\item{fdr_bh_ave}{true false discovery rate when controlling FDR 
                          by Benjamini and Hochberg (1995) method.}

\item{pow_bh_ave}{average power when controlling FDR 
                          by q-value procedure (Storey et al., 2004).}

\item{fdr_bh_ave}{true false discovery rate when controlling FDR
                          by q-value procedure (Storey et al., 2004).}
}
\description{
For the limma/voom RNAseq analysis pipeline, when we control false discovery
rate by using the Benjamini and Hochberg step-up procedure (1995) 
and/or Storey and Tibshirani's q-value procedure (Storey et al, 2004),
\code{check.power} calculates average power and true FDR for given sample 
size, user-specified proportions of non-differentially expressed genes, 
number of iterations, FDR level to control, mean counts in control group, 
dispersion, and fold change.
}
\examples{
library(limma)
library(qvalue)
m <- 14                      ## sample size per treatment group
mu <- 10                     ## mean read counts in control group
disp <- 0.1                  ## dispersion for all genes
fc <- 2                      ## 2-fold change for DE genes

check.power(m = m, mu = mu, disp = disp, fc = fc, sims = 2)

}
\author{
Ran Bi \email{biranpier@gmail.com}, 
        Peng Liu \email{pliu@iastate.edu}
}
\references{
Benjamini, Y. and Hochberg, Y. (1995) 
            Controlling the false discovery rate: a practical and 
            powerful approach to multiple testing. 
            \emph{J. R. Stat. Soc. B}, 57, 289-300.

            Storey, J. D., Taylor, J. E. and Siegmund, D. (2004)
            Strong control, conservative point estimation and 
            simultaneous rates: a unified approach. 
            \emph{J. R. Stat. Soc. B}, 66, 187- 205.
}

