% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmanBS.R
\name{HeckmanBS}
\alias{HeckmanBS}
\title{Heckman-BS Model Fit Function}
\usage{
HeckmanBS(selection, outcome, data = sys.frame(sys.parent()), start = NULL)
}
\arguments{
\item{selection}{A formula object specifying the selection equation.}

\item{outcome}{A formula object specifying the primary outcome equation.}

\item{data}{A data frame containing the variables in the model.}

\item{start}{An optional numeric vector of initial parameter values. If not provided, default values are used.}
}
\value{
A list containing:
\itemize{
  \item \code{coefficients}: A named numeric vector of estimated model parameters.
  \item \code{value}: The value of the likelihood function at the optimum.
  \item \code{loglik}: The (negative) maximum log-likelihood.
  \item \code{counts}: Number of gradient evaluations performed.
  \item \code{hessian}: The Hessian matrix at the optimum.
  \item \code{fisher_infoBS}: The (approximate) Fisher information matrix.
  \item \code{prop_sigmaBS}: Approximate standard errors (square root of the Fisher information diagonal).
  \item \code{level}: Levels of the selection variable.
  \item \code{nObs}: Number of observations in the dataset.
  \item \code{nParam}: Number of parameters estimated.
  \item \code{N0}: Number of observations where the selection variable is zero.
  \item \code{N1}: Number of observations where the selection variable is one.
  \item \code{NXS}: Number of parameters in the selection equation.
  \item \code{NXO}: Number of parameters in the outcome equation.
  \item \code{df}: Degrees of freedom (observations minus number of parameters).
  \item \code{aic}: Akaike Information Criterion.
  \item \code{bic}: Bayesian Information Criterion.
  \item \code{initial.value}: Initial values used in the optimization.
}
}
\description{
Fits the Heckman Sample Selection Model based on the Birnbaum-Saunders (BS) bivariate distribution.
This function implements the maximum likelihood estimation of the model parameters.
}
\details{
The function estimates the parameters of the Heckman-BS model, which extends the classical Heckman model
by assuming that the error terms follow a bivariate Birnbaum-Saunders distribution.
The model has the same number of parameters as the classical Heckman model, including the correlation coefficient
between the error terms. The optimization is performed using the \code{optim} function with the BFGS method.

The estimated quantities include:
\itemize{
  \item Coefficients of the selection equation.
  \item Coefficients of the outcome equation.
  \item Estimated \code{sigma} (scale parameter of the outcome equation's error term).
  \item Estimated \code{rho} (correlation coefficient between the error terms).
}
Additional outputs include measures of model fit, standard errors (approximated by the square root of
the diagonal of the inverse Fisher information matrix), and diagnostic information.
}
\examples{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeBS <- ambexp ~ age + female + educ + blhisp + totchr + ins
HeckmanBS(selectEq, outcomeBS, data = MEPS2001)

}
\references{
\insertAllCited{}
}
