% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Student_densities_Cpp}
\alias{Student_densities_Cpp}
\title{Calculate log multivariate Student's t densities}
\usage{
Student_densities_Cpp(obs, means, covmats, alpha_mt, df)
}
\arguments{
\item{obs}{a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the vector
\eqn{y_{i}=(y_{1i},...,y_{di})} \eqn{(dx1)}. That is, the initial values are
excluded but the last observations is included.}

\item{means}{a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the
conditional mean of the process \eqn{\mu_{y,i}}.}

\item{covmats}{a \eqn{(d \times d \times M)} array such that the slice \code{[, , m]}
contains the conditional covariance matrix of regime m.}

\item{alpha_mt}{a \eqn{(T \times M)} matrix such that \code{[t, m]} contains the time t
transition weights of the \eqn{m}th regime.}

\item{df}{the degrees of freedom parameter value (assumed larger than two).}
}
\value{
a numeric vector containing the multivariate Student's t densities, excluding the constant term.
}
\description{
Calculates logs of multivariate Student t densities with varying mean
  and varying covariance matrix AND EXCLUDING the constant term of the density
  (the constant is calculated and added in R code). The varying conditional covariance
  matrix is calculated within the function from the regime covariance matrices and
  transition weights.
}
\details{
Note that the parametrization is with the covariance matrix and not the scale matrix.
}
\keyword{internal}
