% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcal.R
\name{create_Fi_matrix}
\alias{create_Fi_matrix}
\title{Create Matrix F_i}
\usage{
create_Fi_matrix(i, T_obs)
}
\arguments{
\item{i}{Integer, the lag for which the matrix is constructed, corresponding to the sub-diagonal filled with 1's.}

\item{T_obs}{Integer, the number of time periods or observations in the dataset, corresponding to the dimensions of the matrix.}
}
\value{
A \eqn{(T_obs \times T_obs)} matrix with 1's on the \code{(i+1)}-th sub-diagonal and 0's elsewhere.
}
\description{
\code{create_Fi_matrix} function generates a \eqn{(T_obs \times T_obs)} matrix
with 1's on the \code{(i+1)}-th sub-diagonal and 0's elsewhere.
}
\details{
Used in \code{Portmanteau_test}. The matrix \eqn{F_i} in Lütkepohl (2005), p.158.
}
\references{
\itemize{
   \item Lütkepohl, H. (2005). New Introduction to Multiple Time Series Analysis. Springer.
 }
}
\keyword{internal}
