% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_Bt_Cpp}
\alias{get_Bt_Cpp}
\title{Calculate the impact matrix \eqn{B_t} for all \eqn{t} for models with a non-Gaussian
 conditional distribution with mutually independent shocks.}
\usage{
get_Bt_Cpp(all_Omegas, alpha_mt)
}
\arguments{
\item{all_Omegas}{A cube (3D array) of impact matrices, with each slice being an inveritble square matrix.}

\item{alpha_mt}{A matrix of weights, with as many columns as there are slices in \code{all_Omegas}.}
}
\value{
An arma::cube value (3D array in R) such that each slice contains the weighted sum of the matrices,
  i.e, the impact matrix \eqn{B_t} for all \eqn{t}.
}
\description{
This internal function takes a cube of matrices (\code{all_Omegas}) and a matrix of weights (\code{alpha_mt}),
and calculates the weighted sums of the matrices in the cube. For each row in \code{alpha_mt}, it computes
a weighted sum of matrices, and returns the (3D array) such that each slice contains the weighted sum of the matrices.
Note that the argument \code{all_Omegas} should contain the impact matrices of the regimes (and not the covariance matrices).
}
\keyword{internal}
