% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_ssccheck}
\alias{eempf_ssccheck}
\title{Check SSCs between different models or initialisations of one model}
\usage{
eempf_ssccheck(pfmodels, best = length(pfmodels), tcc = FALSE)
}
\arguments{
\item{pfmodels}{list of parafac models}

\item{best}{number of models with the highest R^2 to be used, default is all models}

\item{tcc}{logical, if TRUE, TCC instead of SSC is calculated}
}
\value{
data.frame containing SSCs
}
\description{
Check SSCs between different models or initialisations of one model
}
\examples{
data(pf_models)

eempf_ssccheck(pf3[1:2])

\donttest{
# SSCs of split-half models, models need to be unlisted
data(sh)
eempf_ssccheck(unlist(sh, recursive = FALSE))
}
}
