% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_residuals_metrics}
\alias{eempf_residuals_metrics}
\title{Calculate residual metrics from a PARAFAC model}
\usage{
eempf_residuals_metrics(residuals, leverage)
}
\arguments{
\item{residuals}{data.frame as derived from \code{\link[staRdom]{eempf_residuals}}}

\item{leverage}{list of data.frames as derived from \code{\link[staRdom]{eempf_leverage}}}
}
\value{
a list of data.frames containing residuals metrics for each sample, emission and excitation wavelength
}
\description{
The metrics calculated with this function are:
\itemize{
\item RSS: residual sum of squares
\item MAE: mean absolute error
\item SAE: sum of absolute errors
\item RSAE: sum of absolute error in relation to the sum of fluorescence and
\item LEV: the leverage as described in \code{\link[staRdom]{eempf_leverage}}
The example contains a way to plot these numbers.
}
}
\examples{
\donttest{
data(eem_list)
data(pf_models)

residuals <- eempf_residuals(pf4[[1]], eem_list, cores = 2)
leverage <- eempf_leverage(pf4[[1]])

metrics <- eempf_residuals_metrics(residuals, leverage)

metrics$sample

## plot different residual metrics
require(dplyr)
require(tidyr)
require(ggplot2)

lapply(names(metrics), function(name){
  metrics[[name]] \%>\%
  mutate(mode = name, element = !!sym(name))
}) \%>\%
  bind_rows() \%>\%
  pivot_longer(cols = RSS:LEV, names_to = "metric", values_to = "value") \%>\%
  # uncomment the following line to select certain metrics
  # filter(metric \%in\% c("RSS","LEV")) \%>\%
  ggplot(aes(x = element, y = value, colour = metric))+
  geom_point()+
  facet_wrap(mode ~ ., ncol = 3, scales = "free")+
  theme(axis.text.x = element_text(angle = 90))+
  scale_y_continuous(trans="log")
}
}
