% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption_functions.R
\name{abs_parms}
\alias{abs_parms}
\title{Calculating slopes and slope ratios of a data frame of absorbance data.}
\usage{
abs_parms(
  abs_data,
  cuvle = NULL,
  unit = c("absorbance", "absorption"),
  add_as = NULL,
  limits = list(c(275, 295), c(350, 400), c(300, 700)),
  l_ref = list(275, 350, 300),
  S = TRUE,
  lref = FALSE,
  p = FALSE,
  model = FALSE,
  Sint = FALSE,
  interval = 21,
  r2threshold = 0.8,
  cores = parallel::detectCores(logical = FALSE),
  verbose = FALSE
)
}
\arguments{
\item{abs_data}{data frame containing absorbance data.}

\item{cuvle}{cuvette (path) length in cm, ignored if unit is absorption}

\item{unit}{unit of absorbance data: if "absorbance", absorbance data is multiplied by log(10) = 2.303 for slope calculations}

\item{add_as}{additionally to a254 and a300, absorbance at certain wavelengths can be added to the table}

\item{limits}{list with vectors containig upper and lower bounds of wavelengeth ranges to be fitted}

\item{l_ref}{list with reference wavelengths, same length as limits}

\item{S}{logical, include slope indices in the table}

\item{lref}{logical, include reference wavelength in the table}

\item{p}{logical, include ps of the coefficients in the table}

\item{model}{logical, include complete model in data frame}

\item{Sint}{logical, wether the spectral curve is calculated interval-wise (\code{\link[cdom]{cdom_spectral_curve}})}

\item{interval}{passed on to \code{\link[cdom]{cdom_spectral_curve}}}

\item{r2threshold}{passed on to \code{\link[cdom]{cdom_spectral_curve}}}

\item{cores}{number of cores to be used for parallel processing}

\item{verbose}{logical, additional information is provided}
}
\value{
A data frame containing the adsorption slopes and slope ratios in column, one line for each sample.
}
\description{
Calculating slopes and slope ratios of a data frame of absorbance data.
}
\details{
The absorbance data is a data frame with the first column called "wavelength" containg the wavelength. Each other column contains the data from one sample. You can use \link{absorbance_read} to read in appropriate data.

The following spectral parameters are calculated:
\itemize{
   \item $S_{275-295}$ slope between 275 and 295 nm calculated with nonlinear regression
   \item $S_{350-400}$ slope between 350 and 400 nm calculated with nonlinear regression
   \item $S_{300-700}$ slope between 275 and 295 nm calculated with nonlinear regression
   \item SR slope ratio, calculated by $S_{275-295}$/$S_{350-400}$
   \item E2:E3 ratio $a_{250}$/$a_{365}$
   \item E4:E6 ratio $a_{465}$/$a_{665}$
   \item $a_{254}$ absorbance at 254 nm
   \item $a_{300}$ absorbance at 300 nm
   }
Depending on available wavelength range, values might be NA.
Additionally other wavelength limits can be defined. The slope ratio might fail in this case.
For further details please refer to Helm et al. (2008).
}
\examples{
\donttest{
data(absorbance)

a1 <- abs_parms(absorbance, cuvle = 5, verbose = TRUE, cores = 2)
a2 <- abs_parms(absorbance, cuvle = 5,l_ref=list(NA,NA,NA), lref=TRUE, cores = 2) # fit lref as well
}
}
\references{
Helms, J., Kieber, D., Mopper, K. 2008. Absorption spectral slopes and slope ratios as indicators of molecular weight, source, and photobleaching of chromophoric dissolved organic matter. Limnol. Oceanogr., 53(3), 955–969
\url{https://aslopubs.onlinelibrary.wiley.com/doi/pdf/10.4319/lo.2008.53.3.0955}
}
