% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig_char.R
\docType{class}
\name{report_mig_char-class}
\alias{report_mig_char-class}
\alias{report_mig_char}
\title{Migration report along with quantitative and
qualitative characteristics}
\description{
Migration along with qualitative or quantitative characteristics or both
(e.g.) weight of eels according to the size class per period of time, weight
of fish according to gender, number of fish per age class. This class does not split migration evenly over 
time period. So, unlike calculations made in class report_mig and report_mig_mult
the whole time span of the migration operation is not considered, only  the date of beginning of 
the operation is used to perform calculations.
}
\section{Slots}{

\describe{
\item{\code{calcdata}}{A 'list' of calculated data, filled in by the calcule method}

\item{\code{data}}{A \code{data.frame} inherited from \link{report_sample_char-class}}

\item{\code{dc}}{An object of class \link{ref_dc-class} inherited from \link{report_sample_char-class}}

\item{\code{taxa}}{An object of class \link{ref_taxa-class} inherited from \link{report_sample_char-class}}

\item{\code{stage}}{An object of class \link{ref_stage-class} inherited from \link{report_sample_char-class}}

\item{\code{horodatedebut}}{An object of class \link{ref_horodate-class} inherited from \link{report_sample_char-class}}

\item{\code{horodatefin}}{An object of class \link{ref_horodate-class} inherited from \link{report_sample_char-class}}

\item{\code{par}}{An object of class \link{ref_par-class} inherited from \link{report_sample_char-class}}

\item{\code{echantillon}}{An object of class \link{ref_choice-class}, vector of choice}

\item{\code{parquan}}{An object of class \link{ref_parquan-class}, quantitative parameter}

\item{\code{parqual}}{An object of class \link{ref_parqual-class}, qualitative parameter}
}}

\note{
The main difference between this class and \link{report_sample_char-class} is that this class allows to
select (or not) the samples, and that it handles quantitative and qualitative parameters separately.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('report_mig_char', ...)}.  they are loaded by the interface
using interface_report_mig_char function.
}

\examples{
require(stacomiR)

stacomi(
	database_expected=FALSE, sch='logrami')
# this requires a database with the schema logrami
# prompt for user and password but you can set appropriate options for host, port and dbname
\dontrun{
	stacomi(database_expected=TRUE, sch='logrami')	
	if (interactive()){
		if (!exists("user")){
			user <- readline(prompt="Enter user: ")
			password <- readline(prompt="Enter password: ")	
		}	
	}
	options(					
			stacomiR.dbname = "bd_contmig_nat",
			stacomiR.host ="localhost",
			stacomiR.port = "5432",
			stacomiR.user = user,
			stacomiR.user = password						
	)	
  r_mig_char <- new("report_mig_char")
  # here parqual is not in the list
  # so this is equivalent to parqual=NULL
  # default for echantillon is "with"
  r_mig_char <- choice_c(r_mig_char,
	  dc=c(107,108,101),
	  taxa=c("Salmo salar"),
	  stage=c('5','11','BEC','BER','IND'),
	  parquan=c('C001','1786','1785'),
	  horodatedebut="2012-01-01",
	  horodatefin="2012-12-31",
	  silent=FALSE)
  # r_mig_char<-charge(r_mig_char) not necessary there
  r_mig_char <- connect(r_mig_char)
  
}	
# load the dataset generated by previous lines
data("r_mig_char")

r_mig_char<-calcule(r_mig_char, silent=TRUE)
plot(r_mig_char,plot.type="quant", silent=TRUE)
# one quantitative parameter found, manual choice of color
plot(r_mig_char,plot.type="quant",color_parm=c("C001"="red"), silent=TRUE)
# age will be plotted as a qualitative variable
# here we split size data accoding to the limit known between different ages from
# scale reading in the Loire
r_mig_char <- setasqualitative(r_mig_char,par='C001',
		breaks=c(0,675,850,2000),
		labels=c("age 1","age 2","age 3"))
r_mig_char<-calcule(r_mig_char, silent=TRUE)
plot(r_mig_char, plot.type="qual", silent=TRUE)
plot(r_mig_char, plot.type="crossed")
plot(r_mig_char, plot.type="crossed",
    color_parm=c("age 1"="#379ec6","age 2"="#173957","age 3"="#b09953"))
xt<-xtable(r_mig_char)
# use method print.xtable to get the output


}
\seealso{
Other report Objects: 
\code{\link{report_annual-class}},
\code{\link{report_dc-class}},
\code{\link{report_df-class}},
\code{\link{report_env-class}},
\code{\link{report_ge_weight-class}},
\code{\link{report_mig-class}},
\code{\link{report_mig_env-class}},
\code{\link{report_mig_interannual-class}},
\code{\link{report_mig_mult-class}},
\code{\link{report_sample_char-class}},
\code{\link{report_sea_age-class}},
\code{\link{report_silver_eel-class}},
\code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
\concept{report Object}
\concept{report Objects}
\keyword{classes}
