#' Stage-Structured Population modelling
#' 
#' stagePop can be used to model the dynamics and interactions of stage-structured populations (i.e. where the life cycle consists of distinct stages - e.g. eggs, juveniles and reproductive adults) in continuous time. It can be used to model predator-prey interactions, host-parasitoid interactions, resource competition and the effects of environmental change on stage-structured species. The model is based on the formulation described by RM Nisbet and WSC Gurney in 1983 in the paper 'The systematic formulation of population models for insects with dynamically varying instar duration. Theoretical Population Biology, 23, 114-135'.  It uses delay differential equations which are solved using the R-packages 'deSolve' or 'PBSddesolve'. 
#' @name stagePop-package
#' @import PBSddesolve deSolve
#' @aliases stagePop-package stagePop
#' @docType package
#' @author Helen Kettle
#' @references To be done
#' @keywords package programming
NULL

