% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staple_binmat.R
\name{staple_bin_mat}
\alias{staple_bin_mat}
\title{STAPLE on binary matrix}
\usage{
staple_bin_mat(x, sens_init = 0.99999, spec_init = 0.99999,
  max_iter = 10000, tol = .Machine$double.eps, prior = "mean",
  verbose = TRUE, trace = 25)
}
\arguments{
\item{x}{a nxr matrix where there are n raters and r elements rated}

\item{sens_init}{Initialize parameter for sensitivity (p)}

\item{spec_init}{Initialize parameter for specificity (q)}

\item{max_iter}{Maximum number of iterations to run}

\item{tol}{Tolerance for convergence}

\item{prior}{Either "mean" or a vector of prior probabilities,}

\item{verbose}{print diagnostic messages}

\item{trace}{Number for modulus to print out verbose iterations}
}
\value{
List of output sensitivities, specificities, and
vector of probabilities
}
\description{
STAPLE on binary matrix
}
\examples{
n = 5
r = 1000
sens = c(0.8, 0.9, 0.8, 0.5, 0.8)
spec = c(0.9, 0.75, 0.99, 0.98, 0.92)
suppressWarnings(RNGversion("3.5.0"))
set.seed(20171120)
n_1 = 200
n_0 = r - n_1
truth = c(rep(0, n_0), rep(1, n_1))
pred_1 = rbinom(n = n, size = n_1, prob = sens)
pred_0 = rbinom(n = n, size = n_0, prob = spec)
pred_0 = sapply(pred_0, function(n) {
   sample(c(rep(0, n), rep(1, n_0 -n)))
})
pred_1 = sapply(pred_1, function(n) {
   sample(c(rep(1, n), rep(0, n_1 -n)))
})
pred = rbind(pred_0, pred_1)
true_sens = colMeans(pred[ truth == 1, ])
true_spec = colMeans(1-pred[ truth == 0, ])
x = t(pred)
staple_out = staple_bin_mat(x)
staple_out_prior = staple_bin_mat(x, prior = rep(0.5, r))

}
