% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_from.R
\name{split_from}
\alias{split_from}
\title{Splits single input PDF document into parts from given points}
\usage{
split_from(pg_num, input_filepath = NULL, output_directory = NULL,
  prefix = "part")
}
\arguments{
\item{pg_num}{A vector of non-negative integers. Split the pdf document into parts from the numbered pages.}

\item{input_filepath}{the path of the input PDF file.
The default is set to NULL. IF NULL, it  prompt the user to
select the folder interactively.}

\item{output_directory}{the path of the output directory}

\item{prefix}{A string for output filename prefix}
}
\value{
this function splits a single input PDF document into
individual pages
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to Split a single input PDF document
into two parts from a given point

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
# Split the pdf from page 10
split_from(pg_num=10)
}

\dontrun{
dir <- tempdir()
require(lattice)
for(i in 1:4) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}
staple_pdf(input_directory = dir, output_filepath = file.path(dir, 'Full_pdf.pdf'))
input_path <- file.path(dir, "Full_pdf.pdf")
split_from(pg_num=2, input_filepath = input_path ,output_directory = dir )
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Priyanga Dilini Talagala and Ogan Mancarci
}
