% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_pdf.R
\name{get_fields}
\alias{get_fields}
\title{Get form fields from a pdf form}
\usage{
get_fields(input_filepath = NULL)
}
\arguments{
\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}
}
\value{
A list of fields. With type, name and value components. To use with
  \code{\link{set_fields}} edit the value element of the fields you want to
  modify. If the field of type "button", the value will be a factor. In this
  case the factor levels describe the possible values for the field. For
  example for a checkbox the typical level names would be "Off" and "Yes",
  corresponding to non checked and checked states respectively.
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to get form fields from a pdf file.

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
pdfFile = system.file('testForm.pdf',package = 'staplr')
fields = get_fields(pdfFile)
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\seealso{
\code{link{set_fields}}
}
\author{
Ogan Mancarci
}
