% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_model_define_dimension.R
\name{define_dimension}
\alias{define_dimension}
\alias{define_dimension.dimensional_model}
\title{Define dimensions in a \code{dimensional_model} object}
\usage{
define_dimension(st, name = NULL, attributes = NULL)

\method{define_dimension}{dimensional_model}(st, name = NULL, attributes = NULL)
}
\arguments{
\item{st}{A \code{dimensional_model} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}
}
\value{
A \code{dimensional_model} object.
}
\description{
To define a dimension in a \code{dimensional_model} object, we have to define its
name and the set of attributes that make it up.
}
\details{
To get a star schema (a \code{star_schema} object) we need a flat table
(implemented through a \code{tibble}) and a \code{dimensional_model} object. The
definition of dimensions in the \code{dimensional_model} object is made from the
flat table column names. Using the \code{dput} function we can list the column
names of the flat table so that we do not have to type their names.
}
\examples{
library(tidyr)

# dput(colnames(mrs_age))
#
# c(
#   "Reception Year",
#   "Reception Week",
#   "Reception Date",
#   "Data Availability Year",
#   "Data Availability Week",
#   "Data Availability Date",
#   "Year",
#   "WEEK",
#   "Week Ending Date",
#   "REGION",
#   "State",
#   "City",
#   "Age Range",
#   "Deaths"
# )

dm <- dimensional_model() \%>\%
  define_dimension(name = "When",
                   attributes = c("Week Ending Date",
                                  "WEEK",
                                  "Year")) \%>\%
  define_dimension(name = "When Available",
                   attributes = c("Data Availability Date",
                                  "Data Availability Week",
                                  "Data Availability Year")) \%>\%
  define_dimension(name = "Where",
                   attributes = c("REGION",
                                  "State",
                                  "City")) \%>\%
  define_dimension(name = "Who",
                   attributes = c("Age Range"))

}
\seealso{


Other star definition functions: 
\code{\link{define_fact}()},
\code{\link{dimensional_model}()}
}
\concept{star definition functions}
