% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/constellation_modify_conformed_dimension_records.R
\name{modify_conformed_dimension_records}
\alias{modify_conformed_dimension_records}
\alias{modify_conformed_dimension_records.constellation}
\title{Apply dimension record update operations to conformed dimensions}
\usage{
modify_conformed_dimension_records(ct, updates = record_update_set())

\method{modify_conformed_dimension_records}{constellation}(ct, updates = record_update_set())
}
\arguments{
\item{ct}{A \code{constellation} object.}

\item{updates}{A \code{record_update_set} object.}
}
\value{
A \code{constellation} object.
}
\description{
Given a list of dimension record update operations, they are applied on the conformed
dimensions of the \code{constellation} object. Update operations must be defined
with the set of functions available for that purpose.
}
\details{
When dimensions are defined, records can be detected that must be modified as
part of the data cleaning process: frequently to unify two or more records
due to data errors or missing data. This is not immediate because facts must
be adapted to the new set of dimension instances.

This operation allows us to unify records and automatically propagate
modifications to facts in star schemas.
}
\examples{
library(tidyr)

ct <- ct_mrs \%>\%
  modify_conformed_dimension_records(updates_st_mrs_age)

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{match_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection_general}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
