% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_query_select_fact.R
\name{select_fact}
\alias{select_fact}
\alias{select_fact.dimensional_query}
\title{Select fact}
\usage{
select_fact(dq, name = NULL, measures = NULL, agg_functions = NULL)

\method{select_fact}{dimensional_query}(dq, name = NULL, measures = NULL, agg_functions = NULL)
}
\arguments{
\item{dq}{A \code{dimensional_query} object.}

\item{name}{A string, name of the fact.}

\item{measures}{A vector of measure names.}

\item{agg_functions}{A vector of aggregation function names. If none is
indicated, those defined in the fact table are considered.}
}
\value{
A \code{dimensional_query} object.
}
\description{
To define the fact to be consulted, its name is indicated, optionally, a
vector of names of selected measures and another of aggregation functions are
also indicated.
}
\details{
If the name of any measure is not indicated, only the one corresponding to
the number of aggregated rows is included, which is always included.

If no aggregation function is included, those defined for the measures are
considered.
}
\examples{
library(tidyr)

dq <- dimensional_query(ms_mrs) \%>\%
  select_fact(
    name = "mrs_age",
    measures = c("deaths"),
    agg_functions = c("MAX")
  )

dq <- dimensional_query(ms_mrs) \%>\%
  select_fact(name = "mrs_age",
             measures = c("deaths"))

dq <- dimensional_query(ms_mrs) \%>\%
  select_fact(name = "mrs_age")

}
\seealso{


Other query functions: 
\code{\link{dimensional_query}()},
\code{\link{filter_dimension}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()}
}
\concept{query functions}
