% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_update_set_update_selection.R
\name{update_selection}
\alias{update_selection}
\alias{update_selection.record_update_set}
\title{Update dimension records with a set of values}
\usage{
update_selection(
  updates = NULL,
  dimension,
  columns = vector(),
  old_values = vector(),
  new_values = vector()
)

\method{update_selection}{record_update_set}(
  updates = NULL,
  dimension,
  columns = vector(),
  old_values = vector(),
  new_values = vector()
)
}
\arguments{
\item{updates}{A \code{record_update_set} object.}

\item{dimension}{A \code{dimension_table} object, dimension to update.}

\item{columns}{A vector of column names.}

\item{old_values}{A vector of character values.}

\item{new_values}{A vector of character values.}
}
\value{
A \code{record_update_set} object.
}
\description{
For a dimension, given a vector of column names, a vector of old values and a
vector of new values, it adds an update to the set of updates that modifies
all the records that have the combination of old values in the columns with
the new values in those same columns.
}
\examples{

library(tidyr)

dim_names <- st_mrs_age \%>\%
    get_dimension_names()

where <- st_mrs_age \%>\%
  get_dimension("where")

# head(where, 2)

updates <- record_update_set() \%>\%
  update_selection(
    dimension = where,
    columns = c("city"),
    old_values = c("Bridgepor"),
    new_values = c("Bridgeport")
  )

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{match_records}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection_general}()}
}
\concept{data cleaning functions}
