% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomultistar.R
\name{select_dimension}
\alias{select_dimension}
\alias{select_dimension.dimensional_query}
\title{Select dimension}
\usage{
select_dimension(dq, name = NULL, attributes = NULL)

\method{select_dimension}{dimensional_query}(dq, name = NULL, attributes = NULL)
}
\arguments{
\item{dq}{A \code{dimensional_query} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}
}
\value{
A \code{dimensional_query} object.
}
\description{
To add a dimension in a \code{dimensional_query} object, we have to define its
name and a subset of the dimension attributes. If only the name of the
dimension is indicated, it is considered that all its attributes should be
added.
}
\examples{

dq <- dimensional_query(ms_mrs) |>
  select_dimension(name = "where",
                  attributes = c("city", "state")) |>
  select_dimension(name = "when")

}
\seealso{
Other query functions: 
\code{\link{dimensional_query}()},
\code{\link{filter_dimension}()},
\code{\link{run_query}()},
\code{\link{select_fact}()}
}
\concept{query functions}
