% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmatching.R
\name{Matching}
\alias{Matching}
\alias{dmatching}
\alias{pmatching}
\alias{qmatching}
\alias{rmatching}
\title{The Generalized Matching Distribution}
\usage{
dmatching(x, size, trials = 1, prob = 0, log = FALSE, approx = (trials > 100))

pmatching(
  q,
  size,
  trials = 1,
  prob = 0,
  lower.tail = TRUE,
  log.p = FALSE,
  approx = (trials > 100)
)

qmatching(
  p,
  size,
  trials = 1,
  prob = 0,
  lower.tail = TRUE,
  log.p = FALSE,
  approx = (trials > 100)
)

rmatching(n, size, trials = 1, prob = 0)
}
\arguments{
\item{x, q}{A vector of numeric values to be used as arguments for the mass function}

\item{size}{The size parameter for the generalised matching distribution (number of objects to match)}

\item{trials}{The trials parameter for the generalised matching distribution (number of times the matching game is repeated)}

\item{prob}{The probability parameter for the generalised matching distribution (probability of known match)}

\item{log, log.p}{A logical value specifying whether results should be returned as log-probabilities}

\item{approx}{A logical value specifying whether to use the normal approximation to the distribution}

\item{lower.tail}{A logical value specifying whether the input represents lower or upper tail probabilities}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\value{
\code{dmatching} gives the density, \code{pmatching} gives the distribution function,
\code{qmatching} gives the quantile function and \code{rmatching} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the generalized matching distribution with parameters \code{size}, \code{trials} and \code{prob}. 
The distribution is for the total number of matches over all trials.  In each trial the player 
initially matches objects independently with probability \code{prob} and then allocates remaining
objects using a random permutation.
}
\examples{
x <- rmatching(1000, 5)
tabulate(x)
# No Fours!
# This is actually one of the key properties of the matching distribution.  
# With size parameter n the distribution has support 0,1,2,...,n-2,n (i.e., it 
# cannot give outcome n-1). The reason for this is that in a permutation it 
# is impossible to give n-1 matches. 
# If there are n-1 matches then the last object in the permutation must also be a match.
dmatching(0:5, 5)

}
\references{
O'Neill, B. (2021) A generalised matching distribution for the problem of coincidences.
}
